package net.kldp.beat.upload;

import java.io.File;
import java.io.IOException;

/**
 * FormFile 인터페이스
 */
public interface FormFile {
	/**
	 * Form내에서의 필드명을 돌려준다.
	 * 
	 * @return String fieldName;
	 */
	public String getFieldName();

	/**
	 * 업로드 파일의 컨텐츠 타입을 돌려준다.
	 * 
	 * @return String ContentType
	 */
	public String getContentType();

	/**
	 * 업로드 파일 크기를 돌려준다.
	 * 
	 * @return int fileSize;
	 */
	public int getFileSize();

	/**
	 * 업로드 파일명을 돌려준다.
	 * 
	 * @return String fileName
	 */
	public String getFileName();

	/**
	 * 파일 확장자를 돌려준다.
	 * 
	 * @return String suffix;
	 */
	public String getFileSuffix();

	/**
	 * 업로드한 파일을 복사한다.
	 * 
	 * @param copyFile
	 * @throws IOException
	 */
	public void copyFile(File copyFile) throws IOException;

}