/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import net.kldp.beat.action.ServletPathParser;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.ActionMappingException;

public class ActionMapper {
    private ServletPathParser parser;

    public ActionMapper(String string) {
        this.parser = new ServletPathParser(string, "action");
    }

    public Object createAction() throws ActionMappingException {
        Object obj;
        try {
            String string = this.parser.getTargetClassName();
            obj = Class.forName("web.controller" + string + "Action").newInstance();
        }
        catch (Exception exception) {
            throw new ActionMappingException("can not found action class");
        }
        return obj;
    }

    public String getDefaultView() {
        ActionMapping actionMapping = Config.getMapping(this.parser.getNamespace());
        return actionMapping.getViewLocation() + this.parser.getDefaultView(Config.viewSuffix());
    }

    public Result getDefaultResult() {
        final String[] stringArray = new String[]{};
        return new Result(){

            @Override
            public String name() {
                return "success";
            }

            @Override
            public String[] params() {
                return stringArray;
            }

            @Override
            public String type() {
                return "forward";
            }

            @Override
            public String value() {
                return ActionMapper.this.parser.getDefaultView(Config.viewSuffix());
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Result.class;
            }

            @Override
            public String contentType() {
                return "text/html";
            }

            @Override
            public String[] headers() {
                return stringArray;
            }
        };
    }
}

