/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.ConfigParser;
import net.kldp.beat.exception.ConfigException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final String SYSTEM_FILE = "/net/kldp/beat/configuration/beat.xml";
    private static final String USER_FILE = "/beat.xml";
    private static Log logger = LogFactory.getLog(Config.class);
    private static Class<?> cl;
    private static ConfigParser parser;

    public static int bufferSize() {
        return Config.parser.bufferSize;
    }

    public static boolean devMode() {
        return Config.parser.devMode;
    }

    public static int maxSize() {
        return Config.parser.maxSize;
    }

    public static String saveDir() {
        if (Config.parser.saveDir.equals("")) {
            Config.parser.saveDir = Config.getDefaultTempDir();
        }
        return Config.parser.saveDir;
    }

    public static ActionMapping defaultMapping() {
        return Config.parser.defaultMapping;
    }

    public static ActionMapping getMapping(String string) {
        for (ActionMapping actionMapping : Config.parser.mappings) {
            if (!actionMapping.getMappingLocation().equals(string)) continue;
            return actionMapping;
        }
        return Config.parser.defaultMapping;
    }

    public static String viewType() {
        return Config.parser.viewType;
    }

    public static String viewSuffix() {
        if (Config.parser.viewType.equals("jsp")) {
            return "jsp";
        }
        if (Config.parser.viewType.equals("velocity")) {
            return "vm";
        }
        if (Config.parser.viewType.equals("freemaker")) {
            return "fm";
        }
        return "jsp";
    }

    public static void load(Class<?> clazz) throws ConfigException {
        cl = clazz;
        URL uRL = clazz.getResource(USER_FILE);
        if (uRL != null) {
            try {
                parser = new ConfigParser(new File(uRL.getFile()));
            }
            catch (Exception exception) {
                logger.fatal((Object)exception);
                throw new ConfigException("can not parsing beat configuration file:/beat.xml");
            }
        }
        uRL = clazz.getResource(SYSTEM_FILE);
        File file = new File(uRL.getFile());
        if (!file.exists()) {
            throw new ConfigException("can not found beat configuration file:/net/kldp/beat/configuration/beat.xml");
        }
        try {
            parser = new ConfigParser(file);
            parser.parse();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    public static Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(cl.getResourceAsStream(string));
        return properties;
    }

    private static String getDefaultTempDir() {
        try {
            File file = File.createTempFile(String.valueOf(System.currentTimeMillis()), "test");
            String string = file.getAbsolutePath().replace('\\', '/');
            file.delete();
            return string.substring(0, string.lastIndexOf(47) + 1);
        }
        catch (IOException iOException) {
            logger.fatal((Object)iOException);
            return null;
        }
    }
}

