package net.kldp.beat.map;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * J2EE 종속적인 프로퍼티를 일반적인 Map으로 제공하기위한 추상 클래스입니다. 서브클래스는 이 추상 클래스를 상속하여 다음의 메서드를
 * 구현해야 합니다. 주의:이 클래스는 스레드에 안전하지 않습니다.
 */
abstract class AbstractMap<K, V> implements Map<K, V> {
	private Map<K, V> tempMap = new HashMap<K, V>();

	/**
	 * 프로퍼티의 이름을 리턴합니다.
	 * 
	 * @return
	 */
	abstract Enumeration<K> getAttributeNames();

	/**
	 * 프로퍼티를 삭제합니다.
	 * 
	 * @param key
	 */
	abstract void removeAttribute(K key);

	/**
	 * 프로퍼티를 리턴합니다.
	 * 
	 * @param key
	 * @return
	 */
	abstract V getAttribute(K key);

	/**
	 * 프로퍼티를 설정합니다.
	 * 
	 * @param key
	 * @param value
	 */
	abstract void setAttribute(K key, V value);

	@Override
	public void clear() {
		for (Enumeration<K> e = getAttributeNames(); e.hasMoreElements();) {
			removeAttribute(e.nextElement());
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean containsKey(Object key) {
		if (getAttribute((K) key) != null)
			return true;
		return false;
	}

	@Override
	public boolean containsValue(Object value) {
		for (Enumeration<K> e = getAttributeNames(); e.hasMoreElements();) {
			if (value.equals(getAttribute(e.nextElement())))
				return true;
		}
		return false;
	}

	@Override
	public Set<java.util.Map.Entry<K, V>> entrySet() {
		tempMap.clear();
		for (Enumeration<K> e = getAttributeNames(); e.hasMoreElements();) {
			K key = e.nextElement();
			V value = getAttribute(key);
			tempMap.put(key, value);
		}
		return tempMap.entrySet();
	}

	@SuppressWarnings("unchecked")
	@Override
	public V get(Object key) {
		return getAttribute((K) key);
	}

	@Override
	public boolean isEmpty() {
		Enumeration<K> attributeNames = getAttributeNames();
		if (attributeNames.hasMoreElements())
			return true;
		return false;
	}

	@Override
	public Set<K> keySet() {
		Set<K> set = new HashSet<K>();
		for (Enumeration<K> e = getAttributeNames(); e.hasMoreElements();) {
			set.add(e.nextElement());
		}
		return set;
	}

	@Override
	public V put(K key, V value) {
		setAttribute(key, value);
		return value;
	}

	@Override
	public void putAll(Map<? extends K, ? extends V> m) {
		Set<? extends K> keySet = m.keySet();
		for (K key : keySet) {
			setAttribute(key, m.get(key));
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public V remove(Object key) {
		V obj = getAttribute((K) key);
		removeAttribute((K) key);
		return obj;
	}

	@Override
	public int size() {
		int count = 0;
		for (Enumeration<K> e = getAttributeNames(); e.hasMoreElements();) {
			e.nextElement();
			count++;
		}
		return count;
	}

	@Override
	public Collection<V> values() {
		Set<V> set = new HashSet<V>();
		for (Enumeration<K> e = getAttributeNames(); e.hasMoreElements();) {
			V attribute = getAttribute(e.nextElement());
			set.add(attribute);
		}
		return set;
	}
}