package net.kldp.beat.map;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/**
 * Cookie를 Map으로 제공하기 위한 랩퍼 클래스입니다.
 * 주의 : 쿠키의 실제 적용은 Cookie 객체를 수정하는것만으로 되지 않고,
 * Map의 put메서드를 호출하여 쿠키를 삽입해야 합니다.
 */
public class CookieMap extends AbstractMap<String, Cookie> {

	private HttpServletResponse response;
	private HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();

	public CookieMap(Cookie[] cookieArr, HttpServletResponse response) {
		for (Cookie cookie : cookieArr)
			cookies.put(cookie.getName(), cookie);
		this.response = response;
	}

	@Override
	Cookie getAttribute(String key) {
		return cookies.get(key);
	}

	@Override
	Enumeration<String> getAttributeNames() {
		return Collections.enumeration(cookies.keySet());
	}

	@Override
	void removeAttribute(String key) {
		Cookie cookie = cookies.remove(key);
		cookie.setMaxAge(0);
		response.addCookie(cookie);
	}

	@Override
	void setAttribute(String key, Cookie value) {
		Cookie cookie = cookies.remove(key);
		cookie.setMaxAge(0);
		response.addCookie(cookie);
	}
}