package net.kldp.beat.mock;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class HttpSessionMock implements HttpSession {

	private Map<String, Object> session;
	private long creationTime;
	private int maxInactiveInterval;
	private long lastAccessedTime;

	public HttpSessionMock(Map<String, Object> session) {
		this.session = session;
		this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
	}

	public Map<String, Object> getSessionMap() {
		return session;
	}

	@Override
	public Object getAttribute(String key) {
		setLastAccessedTime();
		return session.get(key);
	}

	private void setLastAccessedTime() {
		lastAccessedTime = System.currentTimeMillis();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Enumeration getAttributeNames() {
		return new Hashtable(session).keys();
	}

	@Override
	public long getCreationTime() {
		return creationTime;
	}

	@Override
	public String getId() {
		return String.valueOf(creationTime);
	}

	@Override
	public long getLastAccessedTime() {
		return lastAccessedTime;
	}

	@Override
	public int getMaxInactiveInterval() {
		return maxInactiveInterval;
	}

	@Override
	public ServletContext getServletContext() {
		return null;
	}

	@SuppressWarnings("deprecation")
	@Override
	public javax.servlet.http.HttpSessionContext getSessionContext() {
		return null;
	}

	@Override
	public Object getValue(String key) {
		return session.get(key);
	}

	@Override
	public String[] getValueNames() {
		return (String[]) session.keySet().toArray();
	}

	@Override
	public void invalidate() {
		session.clear();
	}

	@Override
	public boolean isNew() {
		return true;
	}

	@Override
	public void putValue(String key, Object value) {
		session.put(key, value);
	}

	@Override
	public void removeAttribute(String key) {
		session.remove(key);
	}

	@Override
	public void removeValue(String key) {
		session.remove(key);
	}

	@Override
	public void setAttribute(String key, Object value) {
		setLastAccessedTime();
		session.put(key, value);
	}

	@Override
	public void setMaxInactiveInterval(int arg0) {
		this.maxInactiveInterval = arg0;
	}
}