/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.util.Map;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.AnnotationFinder;
import net.kldp.beat.action.InterceptorStack;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;

public class InterceptorInvoker {
    private InterceptorStack stack;
    private ActionContext context;
    private Object action;

    public InterceptorInvoker(ActionContext actionContext, InterceptorStack interceptorStack, Object object) {
        this.context = actionContext;
        this.stack = interceptorStack;
        this.action = object;
    }

    public void executeSystemInterceptors() throws InterceptorException {
        InterceptorFactory.intecept(this.action, this.stack.getSystemInterceptors(), this.context);
    }

    public void initUserInterceptors() throws InterceptorException {
        this.initInterceptors(this.stack.getBeforeInterceptors());
        this.initInterceptors(this.stack.getAfterInterceptors());
    }

    public boolean executeBeforeInterceptors() throws InterceptorException {
        return this.executeInterceptors(this.action, this.stack.getBeforeInterceptors());
    }

    public boolean executeAfterInterceptors() throws InterceptorException {
        return this.executeInterceptors(this.action, this.stack.getAfterInterceptors());
    }

    private void initInterceptors(Map<UserInterceptor, Annotation> map) throws InterceptorException {
        for (UserInterceptor userInterceptor : map.keySet()) {
            AnnotationFinder annotationFinder = new AnnotationFinder(userInterceptor.getClass());
            annotationFinder.find();
            for (Annotation annotation : annotationFinder.getAnnotations()) {
                InterceptorFactory.intecept(userInterceptor, this.context, annotation);
            }
        }
    }

    private boolean executeInterceptors(Object object, Map<UserInterceptor, Annotation> map) throws InterceptorException {
        boolean bl = true;
        for (UserInterceptor userInterceptor : map.keySet()) {
            if (userInterceptor.intercept(object, map.get(userInterceptor))) continue;
            bl = false;
        }
        return bl;
    }
}

