/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.kldp.beat.configuration.ActionMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ConfigParser {
    boolean devMode;
    String viewType;
    List<ActionMapping> mappings = new ArrayList<ActionMapping>();
    ActionMapping defaultMapping;
    String saveDir;
    int maxSize;
    int bufferSize;
    private Document document;

    public ConfigParser(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(file);
    }

    public ConfigParser(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(string);
    }

    public void parse() {
        Element element = this.document.getDocumentElement();
        for (Element element2 = (Element)element.getFirstChild(); element2 != null; element2 = (Element)element2.getNextSibling()) {
            String string = element2.getNodeName();
            if (string.equals("dev-mode")) {
                this.devMode = Boolean.parseBoolean(this.getData(element2));
                continue;
            }
            if (string.equals("view-type")) {
                this.viewType = this.getData(element2);
                continue;
            }
            if (string.equals("upload")) {
                this.parseUpload(element2);
                continue;
            }
            if (!string.equals("action-mapping")) continue;
            this.parseActionMapping(element2);
        }
    }

    private void parseUpload(Element element) {
        for (element = (Element)element.getFirstChild(); element != null; element = (Element)element.getNextSibling()) {
            String string = element.getNodeName();
            if (string.equals("save-dir")) {
                this.saveDir = this.getData(element);
                continue;
            }
            if (string.equals("max-size")) {
                this.maxSize = Integer.parseInt(this.getData(element));
                continue;
            }
            if (!string.equals("buffer-size")) continue;
            this.bufferSize = Integer.parseInt(this.getData(element));
        }
    }

    private void parseActionMapping(Element element) {
        for (element = (Element)element.getFirstChild(); element != null; element = (Element)element.getNextSibling()) {
            ActionMapping actionMapping = new ActionMapping();
            String string = element.getNodeName();
            for (Element element2 = (Element)element.getFirstChild(); element2 != null; element2 = (Element)element2.getNextSibling()) {
                String string2 = element2.getNodeName();
                if (string2.equals("view-location")) {
                    actionMapping.setViewLocation(this.getData(element2));
                    continue;
                }
                if (string2.equals("mapping-location")) {
                    actionMapping.setMappingLocation(this.getData(element2));
                    continue;
                }
                if (!string2.equals("resources")) continue;
                for (Element element3 = (Element)element2.getFirstChild(); element3 != null; element3 = (Element)element3.getNextSibling()) {
                    String string3 = this.getData(element3);
                    if (string3.equals("")) continue;
                    actionMapping.addResource(string3);
                }
            }
            if (string.equals("default-mapping")) {
                this.defaultMapping = actionMapping;
                continue;
            }
            this.mappings.add(actionMapping);
        }
    }

    private String getData(Element element) {
        Text text = (Text)element.getFirstChild();
        if (text != null) {
            return text.getData().trim();
        }
        return "";
    }
}

