/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.dispatcher;

import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.dispatcher.Dispatch;
import net.kldp.beat.dispatcher.JspViewDispatcher;

public abstract class ViewDispatcher
implements Dispatch {
    protected ServletContext context;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected static final String REDIRECT = "redirect";
    protected static final String FORWARD = "forward";
    protected static final String NOTHING = "nothing";

    public static ViewDispatcher create(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        JspViewDispatcher jspViewDispatcher;
        if ("jsp".equals(Config.viewType())) {
            jspViewDispatcher = new JspViewDispatcher();
        } else if ("velocity".equals(Config.viewType())) {
            jspViewDispatcher = new JspViewDispatcher();
        } else if ("freemaker".equals(Config.viewType())) {
            jspViewDispatcher = new JspViewDispatcher();
        } else {
            throw new ServletException("can not found dispatcher. check configuration file");
        }
        jspViewDispatcher.context = servletContext;
        jspViewDispatcher.request = httpServletRequest;
        jspViewDispatcher.response = httpServletResponse;
        return jspViewDispatcher;
    }

    @Override
    public void dispatch(String string, String string2) throws ServletException, IOException {
        if (string2.equals(REDIRECT)) {
            this.response.sendRedirect(string);
        } else if (string2.equals(FORWARD)) {
            RequestDispatcher requestDispatcher = this.context.getRequestDispatcher(string);
            requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        } else if (!string2.equals(NOTHING)) {
            throw new ServletException("can not dispath Result. unknown type - " + string2);
        }
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    protected String getNamespace() {
        String string = this.request.getServletPath();
        int n = string.indexOf(47, 1);
        if (n > 0) {
            return string.substring(0, string.indexOf(47, 1));
        }
        return "";
    }

    protected String interpretString(String string, Map<String, Object> map) {
        for (String string2 : map.keySet()) {
            Object object = map.get(string2);
            if (object == null) continue;
            string = string.replace("${" + string2 + "}", object.toString());
        }
        return string;
    }

    protected String arrayToParam(String[] stringArray) {
        return this.arrayToParam(stringArray, "&");
    }

    protected String arrayToParam(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray) {
            stringBuffer.append(string2 + string);
        }
        if (stringBuffer.length() < 1) {
            return "";
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    protected String[] parseHeaders(String[] stringArray, Map<String, Object> map) {
        String string = this.interpretString(this.arrayToParam(stringArray, "\n"), map);
        return string.split("\n");
    }

    protected void addHeaders(String[] stringArray, HttpServletResponse httpServletResponse) {
        for (String string : stringArray) {
            String[] stringArray2 = string.split(":");
            httpServletResponse.addHeader(stringArray2[0], stringArray2[1]);
        }
    }

    protected String getViewPath() {
        return Config.getMapping(this.getNamespace()).getViewLocation();
    }
}

