package net.kldp.beat.action;

import net.kldp.beat.exception.ServletPathParseException;

public class ServletPathParser {

	private String path;
	private String suffix;

	public ServletPathParser(String path, String suffix) {
		this.path = path;
		this.suffix = suffix;
	}

	public String getTargetClassName() throws ServletPathParseException {
		String dir = getDirectory(path);
		String file = getFilename(path);
		return slashToDot(dir) + toUppercaseFirstCharactor(cutSuffix(file, suffix));
	}

	public static String getFilename(String path) {
		return path.substring(path.lastIndexOf("/") + 1);
	}

	public static String getDirectory(String path) {
		return path.substring(0, path.lastIndexOf("/") + 1);
	}

	public static String cutSuffix(String servletPath, String suffix) {
		return servletPath.substring(0, servletPath.lastIndexOf(suffix) - 1);
	}

	public static String slashToDot(String servletPath) {
		return servletPath.replaceAll("/", "\\.");
	}

	public static String toUppercaseFirstCharactor(String str) {
		return String.valueOf(str.charAt(0)).toUpperCase() + str.substring(1);
	}

	public String getDefaultView(String viewSuffix) {
		return cutSuffix(path, suffix) + "." + viewSuffix;
	}

	public String getNamespace() {
		System.out.println(path);
		int index = path.indexOf('/', 1);
		if (index > 0)
			return path.substring(0, path.indexOf('/', 1));
		else
			return "";
	}
}