package net.kldp.beat.dispatcher;

import java.io.IOException;

import javax.servlet.ServletException;

import net.kldp.beat.annotation.Result;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

class FreemarkerViewDispatcher extends ViewDispatcher {

	@Override
	public void dispatch(Result input, Object action) throws ServletException, IOException {
	}

	private void freemarkerDispatch(String url, String type, Object action) throws IOException,
			ServletException {
		Configuration cfg = new Configuration();
		cfg.setServletContextForTemplateLoading(context, "WEB-INF/templates");
		Template t = cfg.getTemplate(url);
		try {
			t.process(action, response.getWriter());
		} catch (TemplateException e) {
			throw new ServletException("Error while processing FreeMarker template", e);
		}
	}
}