package net.kldp.beat.dispatcher;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

import javax.servlet.ServletException;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

import net.kldp.beat.action.PropertyCopy;
import net.kldp.beat.annotation.Result;

class VelocityViewDispatcher extends ViewDispatcher {

	@Override
	public void dispatch(Result input, Object action) throws ServletException, IOException {
		String type = input.type().toLowerCase();
		if (type.equals(FORWARD)) {
			String url = getViewPath() + input.value();
			System.out.println(url);
			url = interpretString(url, PropertyCopy.beanToMap(action));
			if (input.params() != null && input.params().length > 0) {
				String param = interpretString(arrayToParam(input.params()), PropertyCopy.beanToMap(action));
				url += "?" + param;
			}
			velocityDispatch(url, type, action);
		} else if (type.equals(REDIRECT)) {
			dispatch(input.value(), type);
		} else if (type.equals(NOTHING)) {
			// nothing
		} else {
			throw new ServletException("can not dispath Result. unknown type - " + type);
		}
	}

	private void velocityDispatch(String url, String type, Object action) {
		VelocityContext velocity = new VelocityContext();
		velocity.put("action", action);
		velocity.put("request", request);
		velocity.put("response", response);
		velocity.put("session", request.getSession());
		velocity.put("application", context);
		velocity.put("base", request.getContextPath());

		Template template = null;
		try {
			try {
				String templateFile = context.getRealPath(url);
				template = Velocity.getTemplate(templateFile);
			} catch (ResourceNotFoundException rnfe) {
				System.out.println("Example : error : cannot find template " + url);
			} catch (ParseErrorException pee) {
				System.out.println("Example : Syntax error in template " + url + ":" + pee);
			}

			BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream()));

			if (template != null)
				template.merge(velocity, writer);

			writer.flush();
			writer.close();
		} catch (Exception e) {

		}
	}
}