package net.kldp.beat.interceptor.assemble;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

/**
 * 인터셉터 컨테이너를 저장하고 로드하는 풀입니다.
 *
 */
public class UserInterceptorContainerPool {
	private static Map<Annotation, UserInterceptorContainer> pool = new HashMap<Annotation, UserInterceptorContainer>();

	/**
	 * 어노테이션을 기반으로 사용자 인터셉터 객체를 얻습니다.
	 * @param annotation
	 * @return
	 * @throws ClassNotFoundException
	 */
	public static UserInterceptorContainer get(Annotation annotation) throws ClassNotFoundException {
		if (!pool.containsKey(annotation)) {
			addInterceptorContainer(annotation);
		}
		return pool.get(annotation);

	}

	private static void addInterceptorContainer(Annotation annotation) throws ClassNotFoundException {
		pool.put(annotation, new UserInterceptorContainer(annotation));
	}
}