package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.web.aware.ServletRequestAware;

/**
 * ServletRequest객체를 주입합니다.
 *
 */
final class ServletRequestInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation) throws InterceptorException {
		try {
			((ServletRequestAware) action).setServletRequest(context.getServletRequest());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}