/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import javax.servlet.ServletException;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.ActionInvoker;
import net.kldp.beat.action.InterceptorInvoker;
import net.kldp.beat.action.InterceptorStack;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.exception.fatal.ActionExecuteException;
import net.kldp.beat.exception.fatal.ResultException;
import net.kldp.beat.message.ResourceManager;
import net.kldp.beat.servlet.ActionMapper;
import net.kldp.beat.system.aware.ValidationAware;
import net.kldp.beat.util.PropertyCopy;

public class ActionService {
    private ActionContext context;
    private ActionMapper mapper;
    private Object action;

    public ActionService(ActionContext actionContext, Object object, ActionMapper actionMapper) {
        this.context = actionContext;
        this.action = object;
        this.mapper = actionMapper;
    }

    public void doService() throws ServletException {
        Result result;
        boolean bl = true;
        ActionInvoker actionInvoker = new ActionInvoker(this.action);
        ResourceManager resourceManager = new ResourceManager(this.mapper.getNamespace());
        InterceptorStack interceptorStack = new InterceptorStack(this.action.getClass());
        InterceptorInvoker interceptorInvoker = new InterceptorInvoker(this.context, interceptorStack, this.action);
        interceptorInvoker.executeSystemInterceptors();
        this.parameterToAction();
        interceptorInvoker.initUserInterceptors();
        bl = interceptorInvoker.executeBeforeInterceptors();
        actionInvoker.executeBefore();
        if (!this.doValidation()) {
            this.returnToInput(interceptorStack.getResult("input"));
            actionInvoker.executeAfter();
            interceptorInvoker.executeAfterInterceptors();
            return;
        }
        if (!bl) {
            actionInvoker.executeAfter();
            interceptorInvoker.executeAfterInterceptors();
            return;
        }
        try {
            String string = actionInvoker.execute();
            result = interceptorStack.hasResults() ? interceptorStack.getResult(string) : this.mapper.getDefaultResult();
        }
        catch (ActionExecuteException actionExecuteException) {
            try {
                result = interceptorStack.getResult("exception");
                this.context.getRequestMap().put("exception", (Object)actionExecuteException);
            }
            catch (ResultException resultException) {
                throw actionExecuteException;
            }
        }
        actionInvoker.executeBeforeResult();
        this.actionToParameter();
        resourceManager.translateResource();
        try {
            resourceManager.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.dispatchView(result);
        actionInvoker.executeAfter();
        interceptorInvoker.executeAfterInterceptors();
        interceptorInvoker.destroyInterceptors();
    }

    private void actionToParameter() {
        PropertyCopy.beanToMap(this.action, this.context.getRequestMap());
    }

    private void parameterToAction() {
        PropertyCopy.mapToBean(this.context.getParameterMap(), this.action);
    }

    private boolean doValidation() {
        if (this.action instanceof ValidationAware) {
            ValidationAware validationAware = (ValidationAware)this.action;
            validationAware.validate();
            if (validationAware.getErrorsMap().size() > 0) {
                return false;
            }
        }
        return true;
    }

    private void dispatchView(Result result) throws ServletException {
        this.context.getDispatcher().dispatch(result, this.action);
    }

    private void returnToInput(Result result) throws ServletException {
        if (result == null) {
            throw new ServletException("can not found Result annotation for input.");
        }
        PropertyCopy.beanToMap(this.action, this.context.getRequestMap());
        this.context.getDispatcher().dispatch(result, this.action);
    }
}

