/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.map;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractMap<K, V>
implements Map<K, V> {
    private Map<K, V> tempMap = new HashMap();

    AbstractMap() {
    }

    abstract Enumeration<K> getAttributeNames();

    abstract void removeAttribute(K var1);

    abstract V getAttribute(K var1);

    abstract void setAttribute(K var1, V var2);

    @Override
    public void clear() {
        Enumeration<K> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.removeAttribute(enumeration.nextElement());
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getAttribute(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        Enumeration<K> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            if (!object.equals(this.getAttribute(enumeration.nextElement()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.tempMap.clear();
        Enumeration<K> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            K k = enumeration.nextElement();
            V v = this.getAttribute(k);
            this.tempMap.put(k, v);
        }
        return this.tempMap.entrySet();
    }

    @Override
    public V get(Object object) {
        return this.getAttribute(object);
    }

    @Override
    public boolean isEmpty() {
        Enumeration<K> enumeration = this.getAttributeNames();
        return enumeration.hasMoreElements();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>();
        Enumeration<K> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    @Override
    public V put(K k, V v) {
        this.setAttribute(k, v);
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Set<K> set = map.keySet();
        for (K k : set) {
            this.setAttribute(k, map.get(k));
        }
    }

    @Override
    public V remove(Object object) {
        V v = this.getAttribute(object);
        this.removeAttribute(object);
        return v;
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration<K> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<V> values() {
        HashSet<V> hashSet = new HashSet<V>();
        Enumeration<K> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            V v = this.getAttribute(enumeration.nextElement());
            hashSet.add(v);
        }
        return hashSet;
    }
}

