/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.system.interceptor;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.annotation.MultipartRequest;
import net.kldp.beat.system.aware.ValidationAware;
import net.kldp.beat.upload.FormFileImpl;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class MultipartInterceptor
implements SystemInterceptor {
    private static Log logger = LogFactory.getLog(MultipartInterceptor.class);

    MultipartInterceptor() {
    }

    @Override
    public void intercept(Object object, ActionContext actionContext, Annotation annotation) throws InterceptorException {
        System.out.println("MULTIPART STARTING....");
        if (!this.isMultipart(actionContext.getServletRequest())) {
            throw new InterceptorException("Multipart/Form-data\uc694\uccad\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
        }
        if (!(annotation instanceof MultipartRequest)) {
            throw new InterceptorException("Multipart\uc5b4\ub178\ud14c\uc774\uc158\uc774 \uc120\uc5b8\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        MultipartRequest multipartRequest = (MultipartRequest)annotation;
        try {
            Map<String, Object> map = this.multipartParser(actionContext.getServletRequest(), multipartRequest);
            System.out.println(map.size());
            actionContext.setParameterMap(map);
        }
        catch (FileUploadException fileUploadException) {
            if (object instanceof ValidationAware) {
                this.addError(object, multipartRequest, fileUploadException);
            }
            throw new InterceptorException((Exception)((Object)fileUploadException));
        }
    }

    private Map<String, Object> multipartParser(HttpServletRequest httpServletRequest, MultipartRequest multipartRequest) throws FileUploadException, InterceptorException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ServletFileUpload servletFileUpload = this.getServletFileUpload();
        if (multipartRequest.size() > 0 && multipartRequest.size() < Config.maxSize()) {
            servletFileUpload.setSizeMax((long)multipartRequest.size());
        } else if (Config.maxSize() > 0) {
            servletFileUpload.setSizeMax((long)Config.maxSize());
        }
        for (Object e : servletFileUpload.parseRequest(httpServletRequest)) {
            FileItem fileItem = (FileItem)e;
            String string = fileItem.getFieldName();
            try {
                if (fileItem.getSize() <= 0L) continue;
                Object object = fileItem.isFormField() ? fileItem.getString("utf-8") : new FormFileImpl(this.saveFile(fileItem));
                if (hashMap.containsKey(string)) {
                    Object[] objectArray = this.addValue(hashMap.get(string), object);
                    hashMap.put(string, objectArray);
                    continue;
                }
                hashMap.put(string, object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)unsupportedEncodingException);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                throw new FileUploadException();
            }
        }
        return hashMap;
    }

    private Object[] addValue(Object object, Object object2) {
        Object[] objectArray;
        if (object.getClass().isArray()) {
            Object[] objectArray2 = (Object[])object;
            objectArray = new Object[objectArray2.length + 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            objectArray[objectArray2.length] = object2;
        } else {
            objectArray = new Object[]{object, object2};
        }
        return objectArray;
    }

    private File saveFile(FileItem fileItem) throws Exception {
        System.out.println("size" + fileItem.getSize());
        String string = Config.saveDir() + "/" + FilenameUtils.getName((String)fileItem.getName()) + "." + System.currentTimeMillis();
        File file = new File(string);
        fileItem.write(file);
        fileItem.delete();
        return file;
    }

    private ServletFileUpload getServletFileUpload() {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        diskFileItemFactory.setSizeThreshold(0x100000);
        diskFileItemFactory.setRepository(new File(Config.saveDir()));
        return new ServletFileUpload((FileItemFactory)diskFileItemFactory);
    }

    private void addError(Object object, MultipartRequest multipartRequest, FileUploadException fileUploadException) throws InterceptorException {
        ValidationAware validationAware = (ValidationAware)object;
        String string = multipartRequest.errorKey();
        String string2 = multipartRequest.errorMessage();
        if (string.equals("") || validationAware.getErrorsMap() == null) {
            throw new InterceptorException((Exception)((Object)fileUploadException));
        }
        validationAware.getErrorsMap().put(string, string2);
    }

    private boolean isMultipart(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContentType().trim().contains("multipart/form-data");
    }
}

