package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.util.Map;

import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.BeforeInterceptor;
import net.kldp.beat.interceptor.DisposeableInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.system.interceptor.InterceptorFactory;

public class InterceptorInvoker {
	private InterceptorStack stack;
	private ActionContext context;
	private Object action;

	public InterceptorInvoker(ActionContext context, InterceptorStack stack,
			Object action) {
		this.context = context;
		this.stack = stack;
		this.action = action;
	}

	public void executeSystemInterceptors() throws InterceptorException {
		InterceptorFactory.intecept(action, stack.getSystemInterceptors(),
				context);
	}

	public void initUserInterceptors() throws InterceptorException {
		initInterceptors(stack.getBeforeInterceptors());
		initInterceptors(stack.getAfterInterceptors());
	}

	public boolean executeBeforeInterceptors() throws InterceptorException {
		return executeInterceptors(action, stack.getBeforeInterceptors());
	}

	public boolean executeAfterInterceptors() throws InterceptorException {
		return executeInterceptors(action, stack.getAfterInterceptors());
	}

	public void destroyInterceptors() throws InterceptorException {
		for (UserInterceptor interceptor : stack.getBeforeInterceptors()
				.keySet()) {
			if (interceptor instanceof DisposeableInterceptor) {
				destroy(interceptor);
			}
		}
		for (UserInterceptor interceptor : stack.getAfterInterceptors()
				.keySet()) {
			if (interceptor instanceof DisposeableInterceptor
					&& !(interceptor instanceof BeforeInterceptor)) {
				destroy(interceptor);
			}
		}
	}

	private void destroy(UserInterceptor interceptor)
			throws InterceptorException {
		((DisposeableInterceptor) interceptor).destroy();
	}

	private void initInterceptors(Map<UserInterceptor, Annotation> interceptors)
			throws InterceptorException {
		AnnotationFinder finder;
		for (UserInterceptor interceptor : interceptors.keySet()) {
			finder = new AnnotationFinder(interceptor.getClass());
			finder.find();
			for (Annotation annotation : finder.getAnnotations()) {
				InterceptorFactory.intecept(interceptor, context, annotation);
			}
		}
	}

	private boolean executeInterceptors(Object action,
			Map<UserInterceptor, Annotation> interceptors)
			throws InterceptorException {
		boolean result = true;
		for (UserInterceptor interceptor : interceptors.keySet()) {
			// Interceptor가 true일경우에만 Action과 View 처리
			if (!interceptor.intercept(action, interceptors.get(interceptor)))
				result = false;
		}
		return result;
	}
}