package net.kldp.beat.message;

/**
 * 메세지 리소스 포멧을 정의하는 클래스입니다.
 * 
 */
public class Message {
	private String message;
	private Object[] args = new Object[0];

	protected Message() {
	}

	public Message(String message) {
		setMessage(message);
	}

	public Message(String message, Object... args) {
		setMessage(message);
		this.args = args;
	}

	public final void setMessage(String message) {
		if (message == null)
			throw new IllegalArgumentException("message is null");
		this.message = message;
	}

	public final void setArgs(Object... args) {
		this.args = args;
	}

	public final String toString() {
		return parseString();
	}

	public static final String format(String message, Object... args) {
		return new Message(message, args).toString();
	}

	private final String parseString() {
		if (args.length == 0)
			return message;
		String msg = message;
		for (int i = 0; i < args.length; i++) {
			msg = msg.replace("\\{" + i + "\\}", args[i].toString());
		}
		return msg;
	}

	@Override
	public int hashCode() {
		return message.length() + message.length() * args.length;
	}

	@Override
	public boolean equals(Object obj) {
		if (this != obj)
			return false;
		if (hashCode() != obj.hashCode())
			return false;
		if (!(obj instanceof Message))
			return false;
		Message msg = (Message) obj;
		if (!message.equals(msg.message))
			return false;
		for (int i = 0; i < args.length; i++) {
			if (!args[i].equals(msg.args[i]))
				return false;
		}
		return true;
	}
}