package net.kldp.beat.servlet;

import net.kldp.beat.action.pool.ActionClassPool;
import net.kldp.beat.exception.UrlMappingException;

/**
 * 액션 클래스를 검색합니다.
 * 
 */
public class ActionClassFinder {
	public static Class<? extends Object> find(String className)
			throws ClassNotFoundException, UrlMappingException {
		Class<? extends Object> clazz = ActionClassPool.get(className);
		if (clazz == null) {
			clazz = findActionClass(className);
			ActionClassPool.put(className, clazz);
		}
		return clazz;
	}

	private static Class<?> findActionClass(String className)
			throws ClassNotFoundException, UrlMappingException {
		String fullClassName = "web.controller" + className + "Action";
		Class<?> clazz = Class.forName(fullClassName);
		try {
			clazz.newInstance();
		} catch (InstantiationException e) {
			throw new UrlMappingException("can not found action class");
		} catch (IllegalAccessException e) {
			throw new UrlMappingException(
					"Can not create new instance of Action class.");
		}
		return clazz;
	}
}