package net.kldp.beat.system.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.aware.HeaderMapAware;

/**
 * Header맵을 주입하는 인터셉터입니다.
 * 
 */
final class HeaderMapInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		try {
			HeaderMapAware aware = (HeaderMapAware) action;
			aware.setHeader(context.getHeaderMap());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}