package net.kldp.beat.system.interceptor;

import java.lang.annotation.Annotation;

import org.springframework.context.ApplicationContext;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.aware.SpringApplicationContextAware;

/**
 * Spring Application Context 객체를 제공합니다.
 */
final class SpringApplicationContextInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		try {
			SpringApplicationContextAware aware = (SpringApplicationContextAware) action;
			ApplicationContext springContext = Config.getSpringContext();
			if(springContext == null)
				throw new InterceptorException("can not injection spring application context");
			aware.setContext(springContext);
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}