/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.wgshim.doclets.ClassSubWriter;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.ConstructorSubWriter;
import com.wgshim.doclets.DeprecatedAPIListBuilder;
import com.wgshim.doclets.FieldSubWriter;
import com.wgshim.doclets.MethodSubWriter;
import com.wgshim.doclets.Standard;
import com.wgshim.doclets.SubWriterHolderWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class DeprecatedListWriter
extends SubWriterHolderWriter {
    public DeprecatedListWriter(String filename) throws IOException {
        super(filename);
    }

    public static void generate(RootDoc root) throws DocletAbortException {
        String filename = "deprecated-list.html";
        try {
            DeprecatedListWriter depr = new DeprecatedListWriter(filename);
            depr.generateDeprecatedListFile(new DeprecatedAPIListBuilder(root));
            ((PrintWriter)((Object)depr)).close();
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateDeprecatedListFile(DeprecatedAPIListBuilder deprapi) throws IOException {
        ClassSubWriter classW = new ClassSubWriter(this);
        FieldSubWriter fieldW = new FieldSubWriter(this);
        MethodSubWriter methodW = new MethodSubWriter(this);
        ConstructorSubWriter consW = new ConstructorSubWriter(this);
        this.printDeprecatedHeader();
        classW.printDeprecatedAPI(deprapi.getDeprecatedClasses(), "doclet.Deprecated_Classes");
        classW.printDeprecatedAPI(deprapi.getDeprecatedInterfaces(), "doclet.Deprecated_Interfaces");
        classW.printDeprecatedAPI(deprapi.getDeprecatedExceptions(), "doclet.Deprecated_Exceptions");
        classW.printDeprecatedAPI(deprapi.getDeprecatedErrors(), "doclet.Deprecated_Errors");
        fieldW.printDeprecatedAPI(deprapi.getDeprecatedFields(), "doclet.Deprecated_Fields");
        methodW.printDeprecatedAPI(deprapi.getDeprecatedMethods(), "doclet.Deprecated_Methods");
        consW.printDeprecatedAPI(deprapi.getDeprecatedConstructors(), "doclet.Deprecated_Constructors");
        this.printDeprecatedFooter();
    }

    protected void printDeprecatedHeader() {
        this.printHeader(this.getText("doclet.Window_Deprecated_List", Standard.configuration().windowtitle));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.Deprecated_API");
        this.h2End();
        this.centerEnd();
    }

    protected void printDeprecatedFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkDeprecated() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navDeprecated");
        this.fontEnd();
        this.navCellEnd();
    }
}

