/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.HtmlDocWriter;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.Util;
import com.wgshim.doclets.AllClassesFrameWriter;
import com.wgshim.doclets.ClassUseMapper;
import com.wgshim.doclets.ClassWriter;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.DeprecatedListWriter;
import com.wgshim.doclets.FrameOutputWriter;
import com.wgshim.doclets.HelpWriter;
import com.wgshim.doclets.PackageFrameWriter;
import com.wgshim.doclets.PackageIndexFrameWriter;
import com.wgshim.doclets.PackageIndexWriter;
import com.wgshim.doclets.PackageListWriter;
import com.wgshim.doclets.PackageTreeWriter;
import com.wgshim.doclets.PackageWriter;
import com.wgshim.doclets.PackagesFileWriter;
import com.wgshim.doclets.SerializedFormWriter;
import com.wgshim.doclets.SingleIndexWriter;
import com.wgshim.doclets.SplitIndexWriter;
import com.wgshim.doclets.StylesheetWriter;
import com.wgshim.doclets.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Standard {
    public static boolean start(RootDoc root) throws IOException {
        try {
            Standard.configuration().setOptions(root);
            new Standard().startGeneration(root);
        }
        catch (DocletAbortException exc) {
            return false;
        }
        return true;
    }

    public static ConfigurationStandard configuration() {
        if (HtmlDocWriter.configuration == null) {
            HtmlDocWriter.configuration = new ConfigurationStandard();
        }
        return (ConfigurationStandard)HtmlDocWriter.configuration;
    }

    protected void startGeneration(RootDoc root) throws DocletAbortException {
        if (root.classes().length == 0) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.No_Public_Classes_To_Document");
            return;
        }
        if (Standard.configuration().topFile.length() == 0) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document");
            return;
        }
        boolean nodeprecated = Standard.configuration().nodeprecated;
        String configdestdir = Standard.configuration().destdirname;
        String confighelpfile = Standard.configuration().helpfile;
        String configstylefile = Standard.configuration().stylesheetfile;
        this.performCopy(configdestdir, confighelpfile);
        this.performCopy(configdestdir, configstylefile);
        ClassTree classtree = new ClassTree(root, nodeprecated);
        if (Standard.configuration().classuse) {
            ClassUseMapper.generate(root, classtree);
        }
        IndexBuilder indexbuilder = new IndexBuilder(root, nodeprecated);
        PackageDoc[] packages = Standard.configuration().packages;
        if (Standard.configuration().createtree) {
            TreeWriter.generate(classtree);
        }
        if (Standard.configuration().createindex) {
            if (Standard.configuration().splitindex) {
                SplitIndexWriter.generate(indexbuilder);
            } else {
                SingleIndexWriter.generate(indexbuilder);
            }
        }
        if (!Standard.configuration().nodeprecatedlist && !nodeprecated) {
            DeprecatedListWriter.generate(root);
        }
        AllClassesFrameWriter.generate(new IndexBuilder(root, nodeprecated, true));
        FrameOutputWriter.generate();
        PackagesFileWriter.generate();
        if (Standard.configuration().createoverview) {
            PackageIndexWriter.generate(root);
        }
        if (packages.length > 1) {
            PackageIndexFrameWriter.generate();
        }
        int i = 0;
        while (i < packages.length) {
            PackageDoc prev = i == 0 ? null : packages[i - 1];
            PackageDoc packagedoc = packages[i];
            PackageDoc next = i + 1 == packages.length ? null : packages[i + 1];
            PackageWriter.generate(packages[i], prev, next);
            if (Standard.configuration().createtree) {
                PackageTreeWriter.generate(packages[i], prev, next, nodeprecated);
            }
            PackageFrameWriter.generate(packages[i]);
            ++i;
        }
        this.generateClassFiles(root, classtree);
        SerializedFormWriter.generate(root);
        PackageListWriter.generate(root);
        if (Standard.configuration().helpfile.length() == 0 && !Standard.configuration().nohelp) {
            HelpWriter.generate();
        }
        if (Standard.configuration().stylesheetfile.length() == 0) {
            StylesheetWriter.generate();
        }
    }

    protected void generateClassFiles(RootDoc root, ClassTree classtree) throws DocletAbortException {
        ClassDoc[] classes = root.specifiedClasses();
        ArrayList<ClassDoc> incl = new ArrayList<ClassDoc>();
        int i = 0;
        while (i < classes.length) {
            ClassDoc cd = classes[i];
            if (cd.isIncluded() && Standard.isGeneratedDoc((Doc)cd)) {
                incl.add(cd);
            }
            ++i;
        }
        ClassDoc[] inclClasses = new ClassDoc[incl.size()];
        int i2 = 0;
        while (i2 < inclClasses.length) {
            inclClasses[i2] = (ClassDoc)incl.get(i2);
            ++i2;
        }
        this.generateClassCycle(inclClasses, classtree, true);
        PackageDoc[] packages = Standard.configuration().packages;
        int i3 = 0;
        while (i3 < packages.length) {
            PackageDoc pkg = packages[i3];
            this.generateClassCycle(pkg.interfaces(), classtree, false);
            this.generateClassCycle(pkg.ordinaryClasses(), classtree, false);
            this.generateClassCycle(pkg.exceptions(), classtree, false);
            this.generateClassCycle(pkg.errors(), classtree, false);
            ++i3;
        }
    }

    protected String classFileName(ClassDoc cd) {
        return String.valueOf(cd.qualifiedName()) + ".html";
    }

    protected void generateClassCycle(ClassDoc[] arr, ClassTree classtree, boolean nopackage) throws DocletAbortException {
        Arrays.sort(arr);
        int i = 0;
        while (i < arr.length) {
            if (!Standard.configuration().nodeprecated || arr[i].tags("deprecated").length <= 0) {
                ClassDoc prev = i == 0 ? null : arr[i - 1];
                ClassDoc curr = arr[i];
                ClassDoc next = i + 1 == arr.length ? null : arr[i + 1];
                ClassWriter.generate(curr, prev, next, classtree, nopackage);
            }
            ++i;
        }
    }

    public static int optionLength(String option) {
        return Standard.configuration().optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) throws IOException {
        return Standard.configuration().validOptions(options, reporter);
    }

    protected void performCopy(String configdestdir, String filename) throws DocletAbortException {
        try {
            String destdir;
            String string = destdir = configdestdir.length() > 0 ? (destdir = String.valueOf(configdestdir) + File.separatorChar) : "";
            if (filename.length() > 0) {
                File helpstylefile = new File(filename);
                String parent = helpstylefile.getParent();
                String helpstylefilename = parent == null ? filename : filename.substring(parent.length() + 1);
                File desthelpfile = new File(String.valueOf(destdir) + helpstylefilename);
                if (!desthelpfile.getCanonicalPath().equals(helpstylefile.getCanonicalPath())) {
                    Standard.configuration();
                    ConfigurationStandard.standardmessage.notice("doclet.Copying_File_0_To_File_1", helpstylefile.toString(), desthelpfile.toString());
                    Util.copyFile((File)desthelpfile, (File)helpstylefile);
                }
            }
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.perform_copy_exception_encountered", exc.toString());
            throw new DocletAbortException();
        }
    }

    public static boolean isGeneratedDoc(Doc doc) {
        if (!Standard.configuration().nodeprecated) {
            return true;
        }
        return doc.tags("deprecated").length == 0;
    }
}

