/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.GetSizeIMG;

public class DiffIMGBuf {
    private DiffIMGBuf() {
    }

    public static boolean comp(short[][] Image1, short[][] Image2) throws ImageGSException {
        return DiffIMGBuf.comp(Image1, Image2, false);
    }

    public static boolean comp(short[][] Image1, short[][] Image2, boolean display) throws ImageGSException {
        boolean retval = true;
        int count = 0;
        if (Image1 == null || Image2 == null) {
            throw new ImageGSException("DiffIMGBuf.comp() >>  Unknown size of GrayIMG or GrayIMG is null");
        }
        int Image1_height = GetSizeIMG.getHeight(Image1);
        int Image1_width = GetSizeIMG.getWidth(Image1);
        int Image2_height = GetSizeIMG.getHeight(Image2);
        int Image2_width = GetSizeIMG.getWidth(Image2);
        if (Image1_height != Image2_height && Image1_width != Image2_width) {
            throw new ImageGSException("DiffIMGBuf.comp() >>  The height, width of two images is not equal.");
        }
        int i = 0;
        while (i < Image1_height) {
            int j = 0;
            while (j < Image2_width) {
                if (Image1[i][j] != Image2[i][j]) {
                    if (!display) {
                        retval = false;
                        break;
                    }
                    System.out.println("[" + i + "," + j + "] " + Image1[i][j] + " <-> " + Image2[i][j]);
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        if (display) {
            System.out.println("Detect count of pixel value of images ==> " + count);
        }
        return retval;
    }

    public static boolean comp(double[][] Image1, double[][] Image2) throws ImageGSException {
        return DiffIMGBuf.comp(Image1, Image2, false);
    }

    public static boolean comp(double[][] Image1, double[][] Image2, boolean display) throws ImageGSException {
        boolean retval = true;
        int count = 0;
        if (Image1 == null || Image2 == null) {
            throw new ImageGSException("DiffIMGBuf.comp() >>  Unknown size of GrayIMG or GrayIMG is null");
        }
        int Image1_height = GetSizeIMG.getHeight(Image1);
        int Image1_width = GetSizeIMG.getWidth(Image1);
        int Image2_height = GetSizeIMG.getHeight(Image2);
        int Image2_width = GetSizeIMG.getWidth(Image2);
        if (Image1_height != Image2_height && Image1_width != Image2_width) {
            throw new ImageGSException("DiffIMGBuf.comp() >>  The height, width of two images is not equal.");
        }
        int i = 0;
        while (i < Image1_height) {
            int j = 0;
            while (j < Image2_width) {
                if (Image1[i][j] != Image2[i][j]) {
                    if (!display) {
                        retval = false;
                        break;
                    }
                    System.out.println("[" + i + "," + j + "] " + Image1[i][j] + " <-> " + Image2[i][j]);
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        if (display) {
            System.out.println("Detect count of pixel value of images ==> " + count);
        }
        return retval;
    }
}

