/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitMaskBuf;

public class Matrix {
    private Matrix() {
    }

    public static short[][] add(short[][] matrix1, short[][] matrix2) throws ImageGSException {
        return Matrix.shortAMD(matrix1, matrix2, 0);
    }

    public static short[][] minus(short[][] matrix1, short[][] matrix2) throws ImageGSException {
        return Matrix.shortAMD(matrix1, matrix2, 1);
    }

    public static short[][] div(short[][] matrix1, short[][] matrix2) throws ImageGSException {
        return Matrix.shortAMD(matrix1, matrix2, 2);
    }

    private static short[][] shortAMD(short[][] matrix1, short[][] matrix2, int method) throws ImageGSException {
        String msg_add = "Matrix.add()";
        String msg_minus = "Matrix.minus()";
        String msg_div = "Matrix.div()";
        short[][] retMatrix = null;
        long tmp = 0L;
        if (matrix1 == null || matrix2 == null) {
            if (method == 0) {
                throw new ImageGSException(String.valueOf(msg_add) + " >> matrix1 or matrix2 is null!");
            }
            if (method == 1) {
                throw new ImageGSException(String.valueOf(msg_minus) + " >> matrix1 or matrix2 is null!");
            }
            if (method == 2) {
                throw new ImageGSException(String.valueOf(msg_div) + " >> matrix1 or matrix2 is null!");
            }
        }
        int matrix1_rows = matrix1.length;
        int matrix1_cols = matrix1[0].length;
        int matrix2_rows = matrix2.length;
        int matrix2_cols = matrix2[0].length;
        if (matrix1_rows != matrix2_rows || matrix1_cols != matrix2_cols) {
            if (method == 0) {
                throw new ImageGSException(String.valueOf(msg_add) + " >> don't match!!! size of matrix1, matrix2");
            }
            if (method == 1) {
                throw new ImageGSException(String.valueOf(msg_minus) + " >> don't match!!! size of matrix1, matrix2");
            }
            if (method == 2) {
                throw new ImageGSException(String.valueOf(msg_div) + " >> don't match!!! size of matrix1, matrix2");
            }
        }
        retMatrix = InitMaskBuf.ShortInitMask(matrix1_rows, matrix1_cols);
        int i = 0;
        while (i < matrix1_rows) {
            int j = 0;
            while (j < matrix1_cols) {
                if (method == 0) {
                    tmp = matrix1[i][j] + matrix2[i][j];
                    if (tmp > 32767L) {
                        throw new ImageGSException(String.valueOf(msg_add) + " >> overflow Short.MAX_VALUE!!");
                    }
                    retMatrix[i][j] = (short)(matrix1[i][j] + matrix2[i][j]);
                } else if (method == 1) {
                    tmp = matrix1[i][j] - matrix2[i][j];
                    if (tmp > 32767L) {
                        throw new ImageGSException(String.valueOf(msg_add) + " >> overflow Short.MAX_VALUE!!");
                    }
                    if (tmp < -32768L) {
                        throw new ImageGSException(String.valueOf(msg_add) + " >> overflow Short.MIN_VALUE!!");
                    }
                    retMatrix[i][j] = (short)(matrix1[i][j] - matrix2[i][j]);
                } else if (method == 2) {
                    retMatrix[i][j] = (short)(matrix1[i][j] / matrix2[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return retMatrix;
    }

    public static short getMinVal(short[][] matrix) throws ImageGSException {
        if (matrix == null) {
            throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
        }
        int height = GetSizeIMG.getHeight(matrix);
        int width = GetSizeIMG.getWidth(matrix);
        short minVal = 10000;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (matrix[i][j] < minVal) {
                    minVal = matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return minVal;
    }

    public static short getMaxVal(short[][] matrix) throws ImageGSException {
        if (matrix == null) {
            throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
        }
        int height = GetSizeIMG.getHeight(matrix);
        int width = GetSizeIMG.getWidth(matrix);
        short maxVal = -10000;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (matrix[i][j] > maxVal) {
                    maxVal = matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return maxVal;
    }

    public static int[][] add(int[][] matrix1, int[][] matrix2) throws ImageGSException {
        return Matrix.intAMD(matrix1, matrix2, 0);
    }

    public static int[][] minus(int[][] matrix1, int[][] matrix2) throws ImageGSException {
        return Matrix.intAMD(matrix1, matrix2, 1);
    }

    public static int[][] div(int[][] matrix1, int[][] matrix2) throws ImageGSException {
        return Matrix.intAMD(matrix1, matrix2, 2);
    }

    private static int[][] intAMD(int[][] matrix1, int[][] matrix2, int method) throws ImageGSException {
        String msg_add = "Matrix.add()";
        String msg_minus = "Matrix.minus()";
        String msg_div = "Matrix.div()";
        int[][] retMatrix = null;
        long tmp = 0L;
        if (matrix1 == null || matrix2 == null) {
            if (method == 0) {
                throw new ImageGSException(String.valueOf(msg_add) + " >> matrix1 or matrix2 is null!");
            }
            if (method == 1) {
                throw new ImageGSException(String.valueOf(msg_minus) + " >> matrix1 or matrix2 is null!");
            }
            if (method == 2) {
                throw new ImageGSException(String.valueOf(msg_div) + " >> matrix1 or matrix2 is null!");
            }
        }
        int matrix1_rows = matrix1.length;
        int matrix1_cols = matrix1[0].length;
        int matrix2_rows = matrix2.length;
        int matrix2_cols = matrix2[0].length;
        if (matrix1_rows != matrix2_rows || matrix1_cols != matrix2_cols) {
            if (method == 0) {
                throw new ImageGSException(String.valueOf(msg_add) + " >> don't match!!! size of matrix1, matrix2");
            }
            if (method == 1) {
                throw new ImageGSException(String.valueOf(msg_minus) + " >> don't match!!! size of matrix1, matrix2");
            }
            if (method == 2) {
                throw new ImageGSException(String.valueOf(msg_div) + " >> don't match!!! size of matrix1, matrix2");
            }
        }
        retMatrix = InitMaskBuf.IntegerInitMask(matrix1_rows, matrix1_cols);
        int i = 0;
        while (i < matrix1_rows) {
            int j = 0;
            while (j < matrix1_cols) {
                if (method == 0) {
                    tmp = matrix1[i][j] + matrix2[i][j];
                    if (tmp > Integer.MAX_VALUE) {
                        throw new ImageGSException(String.valueOf(msg_add) + " >> overflow Integer.MAX_VALUE!!");
                    }
                    retMatrix[i][j] = matrix1[i][j] + matrix2[i][j];
                } else if (method == 1) {
                    tmp = matrix1[i][j] - matrix2[i][j];
                    if (tmp > 32767L) {
                        throw new ImageGSException(String.valueOf(msg_add) + " >> overflow Integer.MAX_VALUE!!");
                    }
                    if (tmp < -32768L) {
                        throw new ImageGSException(String.valueOf(msg_add) + " >> overflow Integer.MIN_VALUE!!");
                    }
                    retMatrix[i][j] = matrix1[i][j] - matrix2[i][j];
                } else if (method == 2) {
                    retMatrix[i][j] = matrix1[i][j] / matrix2[i][j];
                }
                ++j;
            }
            ++i;
        }
        return retMatrix;
    }

    public static int getMinVal(int[][] matrix) throws ImageGSException {
        if (matrix == null) {
            throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
        }
        int height = GetSizeIMG.getHeight(matrix);
        int width = GetSizeIMG.getWidth(matrix);
        int minVal = 10000000;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (matrix[i][j] < minVal) {
                    minVal = matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return minVal;
    }

    public static int getMaxVal(int[][] matrix) throws ImageGSException {
        if (matrix == null) {
            throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
        }
        int height = GetSizeIMG.getHeight(matrix);
        int width = GetSizeIMG.getWidth(matrix);
        int maxVal = -10000000;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (matrix[i][j] > maxVal) {
                    maxVal = matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return maxVal;
    }

    public static double[][] add(double[][] matrix1, double[][] matrix2) throws ImageGSException {
        return Matrix.doubleAMD(matrix1, matrix2, 0);
    }

    public static double[][] minus(double[][] matrix1, double[][] matrix2) throws ImageGSException {
        return Matrix.doubleAMD(matrix1, matrix2, 1);
    }

    public static double[][] div(double[][] matrix1, double[][] matrix2) throws ImageGSException {
        return Matrix.doubleAMD(matrix1, matrix2, 2);
    }

    private static double[][] doubleAMD(double[][] matrix1, double[][] matrix2, int method) throws ImageGSException {
        String msg_add = "Matrix.add()";
        String msg_minus = "Matrix.minus()";
        String msg_div = "Matrix.div()";
        double[][] retMatrix = null;
        if (matrix1 == null || matrix2 == null) {
            if (method == 0) {
                throw new ImageGSException(String.valueOf(msg_add) + " >> matrix1 or matrix2 is null!");
            }
            if (method == 1) {
                throw new ImageGSException(String.valueOf(msg_minus) + " >> matrix1 or matrix2 is null!");
            }
            if (method == 2) {
                throw new ImageGSException(String.valueOf(msg_div) + " >> matrix1 or matrix2 is null!");
            }
        }
        int matrix1_rows = matrix1.length;
        int matrix1_cols = matrix1[0].length;
        int matrix2_rows = matrix2.length;
        int matrix2_cols = matrix2[0].length;
        if (matrix1_rows != matrix2_rows || matrix1_cols != matrix2_cols) {
            if (method == 0) {
                throw new ImageGSException(String.valueOf(msg_add) + " >> don't match!!! size of matrix1, matrix2");
            }
            if (method == 1) {
                throw new ImageGSException(String.valueOf(msg_minus) + " >> don't match!!! size of matrix1, matrix2");
            }
            if (method == 2) {
                throw new ImageGSException(String.valueOf(msg_div) + " >> don't match!!! size of matrix1, matrix2");
            }
        }
        retMatrix = InitMaskBuf.DoubleInitMask(matrix1_rows, matrix1_cols);
        int i = 0;
        while (i < matrix1_rows) {
            int j = 0;
            while (j < matrix1_cols) {
                if (method == 0) {
                    retMatrix[i][j] = matrix1[i][j] + matrix2[i][j];
                } else if (method == 1) {
                    retMatrix[i][j] = matrix1[i][j] - matrix2[i][j];
                } else if (method == 2) {
                    retMatrix[i][j] = matrix1[i][j] / matrix2[i][j];
                }
                ++j;
            }
            ++i;
        }
        return retMatrix;
    }

    public static short[][] multiply(short[][] matrix1, short[][] matrix2) throws ImageGSException {
        short[][] retMatrix = null;
        if (matrix1 == null || matrix2 == null) {
            throw new ImageGSException("Matrix.multiply() >> matrix1 or matrix2 is null!");
        }
        int matrix1_rows = matrix1.length;
        int matrix1_cols = matrix1[0].length;
        int matrix2_rows = matrix2.length;
        int matrix2_cols = matrix2[0].length;
        if (matrix1_cols != matrix2_rows) {
            throw new ImageGSException("Matrix.multiply() >> don't match!!! matrix1's cols : " + matrix1_cols + " and matrix2's rows " + matrix2_rows);
        }
        retMatrix = InitMaskBuf.ShortInitMask(matrix1_rows, matrix2_cols);
        int i = 0;
        while (i < matrix1_rows) {
            int j = 0;
            while (j < matrix2_cols) {
                int k = 0;
                while (k < matrix1_cols) {
                    short[] sArray = retMatrix[i];
                    int n = j;
                    sArray[n] = (short)(sArray[n] + matrix1[i][k] * matrix2[k][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return retMatrix;
    }

    public static int[][] multiply(int[][] matrix1, int[][] matrix2) throws ImageGSException {
        int[][] retMatrix = null;
        if (matrix1 == null || matrix2 == null) {
            throw new ImageGSException("Matrix.multiply() >> matrix1 or matrix2 is null!");
        }
        int matrix1_rows = matrix1.length;
        int matrix1_cols = matrix1[0].length;
        int matrix2_rows = matrix2.length;
        int matrix2_cols = matrix2[0].length;
        if (matrix1_cols != matrix2_rows) {
            throw new ImageGSException("Matrix.multiply() >> don't match!!! matrix1's cols : " + matrix1_cols + " and matrix2's rows " + matrix2_rows);
        }
        retMatrix = InitMaskBuf.IntegerInitMask(matrix1_rows, matrix2_cols);
        int i = 0;
        while (i < matrix1_rows) {
            int j = 0;
            while (j < matrix2_cols) {
                int k = 0;
                while (k < matrix1_cols) {
                    int[] nArray = retMatrix[i];
                    int n = j;
                    nArray[n] = nArray[n] + matrix1[i][k] * matrix2[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return retMatrix;
    }

    public static double[][] multiply(double[][] matrix1, double[][] matrix2) throws ImageGSException {
        double[][] retMatrix = null;
        if (matrix1 == null || matrix2 == null) {
            throw new ImageGSException("Matrix.multiply() >> matrix1 or matrix2 is null!");
        }
        int matrix1_rows = matrix1.length;
        int matrix1_cols = matrix1[0].length;
        int matrix2_rows = matrix2.length;
        int matrix2_cols = matrix2[0].length;
        if (matrix1_cols != matrix2_rows) {
            throw new ImageGSException("Matrix.multiply() >> don't match!!! matrix1's cols : " + matrix1_cols + " and matrix2's rows " + matrix2_rows);
        }
        retMatrix = InitMaskBuf.DoubleInitMask(matrix1_rows, matrix2_cols);
        int i = 0;
        while (i < matrix1_rows) {
            int j = 0;
            while (j < matrix2_cols) {
                int k = 0;
                while (k < matrix1_cols) {
                    double[] dArray = retMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + matrix1[i][k] * matrix2[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return retMatrix;
    }

    public static double getMinVal(double[][] matrix) throws ImageGSException {
        if (matrix == null) {
            throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
        }
        int height = GetSizeIMG.getHeight(matrix);
        int width = GetSizeIMG.getWidth(matrix);
        double minVal = 1.0E7;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (matrix[i][j] < minVal) {
                    minVal = matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return minVal;
    }

    public static double getMaxVal(double[][] matrix) throws ImageGSException {
        if (matrix == null) {
            throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
        }
        int height = GetSizeIMG.getHeight(matrix);
        int width = GetSizeIMG.getWidth(matrix);
        double maxVal = -1.0E7;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (matrix[i][j] > maxVal) {
                    maxVal = matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return maxVal;
    }

    public static void print(short[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        int i = 0;
        while (i < rows) {
            System.out.print("|");
            int j = 0;
            while (j < cols) {
                System.out.print(" " + matrix[i][j]);
                if (j != cols - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.println("| ");
            ++i;
        }
    }

    public static void print(int[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        int i = 0;
        while (i < rows) {
            System.out.print("|");
            int j = 0;
            while (j < cols) {
                System.out.print(" " + matrix[i][j]);
                if (j != cols - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.println("| ");
            ++i;
        }
    }

    public static void print(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        int i = 0;
        while (i < rows) {
            System.out.print("|");
            int j = 0;
            while (j < cols) {
                System.out.print(" " + matrix[i][j]);
                if (j != cols - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.println("| ");
            ++i;
        }
    }
}

