/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.ImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JPanel;

public class RAWImage {
    private String fname;
    private BufferedImage myBufferedImage = null;
    private short[][] RedChannel = null;
    private short[][] GreenChannel = null;
    private short[][] BlueChannel = null;
    private short[][] GrayChannel = null;
    private int alpha = -16777216;
    private int height = 0;
    private int width = 0;
    protected ImagePanel panel;

    public RAWImage(String fname, int height, int width) throws ImageGSException {
        this.fname = fname;
        this.height = height;
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short[][] getRedChannel() {
        return this.RedChannel;
    }

    public short[][] getGreenChannel() {
        return this.GreenChannel;
    }

    public short[][] getBlueChannel() {
        return this.BlueChannel;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    public void load() throws ImageGSException {
        FileInputStream in = null;
        boolean length = false;
        int i = 0;
        int j = 0;
        try {
            in = new FileInputStream(this.fname);
            int b = -1;
            this.RedChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.GreenChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.BlueChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            i = 0;
            while (i < this.height) {
                j = 0;
                while (j < this.width) {
                    short r = (short)in.read();
                    short g = (short)in.read();
                    b = (short)in.read();
                    this.RedChannel[i][j] = r;
                    this.GreenChannel[i][j] = g;
                    this.BlueChannel[i][j] = b;
                    this.GrayChannel[i][j] = (short)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114);
                    ++j;
                }
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    public JPanel getImagePanel() {
        this.panel = new ImagePanel(this.getBufferedImage());
        return this.panel;
    }

    public BufferedImage getBufferedImage() {
        try {
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.color(this.RedChannel, this.GreenChannel, this.BlueChannel, this.height, this.width);
            this.myBufferedImage = cb.getBufferedImage();
        }
        catch (ImageGSException imageGSException) {
            // empty catch block
        }
        return this.myBufferedImage;
    }

    public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.save(OutGrayChannel, OutGrayChannel, OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(String OutFname, short[][] OutRedChannel, short[][] OutGreenChannel, short[][] OutBlueChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutRedChannel, OutGreenChannel, OutBlueChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutRedChannel, short[][] OutGreenChannel, short[][] OutBlueChannel, int OutHeight, int OutWidth) throws ImageGSException {
        BufferedImage outputBufferedImage = null;
        FileOutputStream out = null;
        byte[] rgb = new byte[3];
        try {
            outputBufferedImage = new BufferedImage(OutWidth, OutHeight, 1);
            out = new FileOutputStream(this.fname);
            int i = 0;
            while (i < OutHeight) {
                int j = 0;
                while (j < OutWidth) {
                    short r = OutRedChannel[i][j];
                    short g = OutGreenChannel[i][j];
                    short b = OutBlueChannel[i][j];
                    outputBufferedImage.setRGB(j, i, this.packRGB(r, g, b));
                    int value = outputBufferedImage.getRGB(j, i);
                    rgb[2] = (byte)(value & 0xFF);
                    rgb[1] = (byte)(value >> 8 & 0xFF);
                    rgb[0] = (byte)(value >> 16 & 0xFF);
                    out.write(rgb);
                    ++j;
                }
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    private int packRGB(short r, short g, short b) {
        return this.alpha + 65536 * r + 256 * g + b;
    }
}

