/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.BinaryProc.Binary2GrayIMG;
import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.BufferedImage2Channel;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.ImagePanel;
import com.conv2.imageGS.Util.CopyIMGBuf;
import com.conv2.imageGS.Util.FillIMGBuf;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.TypeConv2GrayIMG;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class TChannelViewer
extends JFrame {
    private TChannelViewer() {
    }

    public static void run(short[][] channel, boolean binaryFlag) throws ImageGSException {
        TChannelViewer.run(channel, true, "\uc774\uc9c4 \uc601\uc0c1\uc785\ub2c8\ub2e4", null);
    }

    public static void run(short[][] channel, boolean binaryFlag, String captionTitle) throws ImageGSException {
        TChannelViewer.run(channel, true, captionTitle, null);
    }

    public static void run(short[][] channel, boolean binaryFlag, String captionTitle, String imageTitle) throws ImageGSException {
        if (binaryFlag) {
            TChannelViewer.run(Binary2GrayIMG.ShortBinary2GrayIMG((short[][])channel), captionTitle, imageTitle);
        } else {
            TChannelViewer.run(channel, captionTitle, imageTitle);
        }
    }

    public static void run(short[][] grayChannel) throws ImageGSException {
        String captionTitle = null;
        TChannelViewer.run(grayChannel, captionTitle, null);
    }

    public static void run(short[][] grayChannel, String captionTitle) throws ImageGSException {
        TChannelViewer.run(grayChannel, captionTitle, null);
    }

    public static void run(short[][] grayChannel, String captionTitle, String imageTitle) throws ImageGSException {
        BufferedImage bi = null;
        String captionTitleStr = "\uba85\uc554\ub3c4 \uc601\uc0c1\uc785\ub2c8\ub2e4.";
        if (captionTitle != null) {
            captionTitleStr = captionTitle;
        }
        String imageTitleStr = "";
        if (imageTitle != null) {
            imageTitleStr = imageTitle;
        }
        try {
            bi = TChannelViewer.makeBufferedImage(grayChannel, imageTitle);
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(captionTitle);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
        }
    }

    public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel) throws ImageGSException {
        TChannelViewer.run(redChannel, greenChannel, blueChannel, null, null);
    }

    public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String title) throws ImageGSException {
        TChannelViewer.run(redChannel, greenChannel, blueChannel, title, null);
    }

    public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String captionTitle, String imageTitle) throws ImageGSException {
        BufferedImage bi = null;
        String captionTitleStr = "\uceec\ub7ec \uc601\uc0c1\uc785\ub2c8\ub2e4.";
        if (captionTitle != null) {
            captionTitleStr = captionTitle;
        }
        String imageTitleStr = "";
        if (imageTitle != null) {
            imageTitleStr = imageTitle;
        }
        try {
            bi = TChannelViewer.makeBufferedImage(redChannel, greenChannel, blueChannel, imageTitle);
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(captionTitle);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
        }
    }

    public static void run(double[][] channel, boolean binaryFlag) throws ImageGSException {
        TChannelViewer.run(channel, true, "\uc774\uc9c4 \uc601\uc0c1\uc785\ub2c8\ub2e4", null);
    }

    public static void run(double[][] channel, boolean binaryFlag, String captionTitle) throws ImageGSException {
        TChannelViewer.run(channel, true, captionTitle, null);
    }

    public static void run(double[][] channel, boolean binaryFlag, String captionTitle, String imageTitle) throws ImageGSException {
        if (binaryFlag) {
            TChannelViewer.run(Binary2GrayIMG.DoubleBinary2GrayIMG((double[][])channel), captionTitle, imageTitle);
        } else {
            TChannelViewer.run(channel, captionTitle, imageTitle);
        }
    }

    public static void run(double[][] grayChannel) throws ImageGSException {
        String captionTitle = null;
        TChannelViewer.run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), captionTitle, null);
    }

    public static void run(double[][] grayChannel, String captionTitle) throws ImageGSException {
        TChannelViewer.run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), captionTitle, null);
    }

    public static void run(double[][] grayChannel, String captionTitle, String imageTitle) throws ImageGSException {
        BufferedImage bi = null;
        String captionTitleStr = "\uba85\uc554\ub3c4 \uc601\uc0c1\uc785\ub2c8\ub2e4.";
        if (captionTitle != null) {
            captionTitleStr = captionTitle;
        }
        String imageTitleStr = "";
        if (imageTitle != null) {
            imageTitleStr = imageTitle;
        }
        try {
            bi = TChannelViewer.makeBufferedImage(grayChannel, imageTitle);
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(captionTitle);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
        }
    }

    public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel) throws ImageGSException {
        TChannelViewer.run(redChannel, greenChannel, blueChannel, null, null);
    }

    public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String captionTitle) throws ImageGSException {
        TChannelViewer.run(redChannel, greenChannel, blueChannel, captionTitle, null);
    }

    public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String captionTitle, String imageTitle) throws ImageGSException {
        BufferedImage bi = null;
        String captionTitleStr = "\uceec\ub7ec \uc601\uc0c1\uc785\ub2c8\ub2e4.";
        if (captionTitle != null) {
            captionTitleStr = captionTitle;
        }
        String imageTitleStr = "";
        if (imageTitle != null) {
            imageTitleStr = imageTitle;
        }
        try {
            bi = TChannelViewer.makeBufferedImage(redChannel, greenChannel, blueChannel, imageTitle);
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(captionTitle);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
        }
    }

    public static void run(BufferedImage bi) throws ImageGSException {
        TChannelViewer.run(bi, null, null);
    }

    public static void run(BufferedImage bi, String captionTitle) throws ImageGSException {
        TChannelViewer.run(bi, captionTitle, null);
    }

    public static void run(BufferedImage bi, String captionTitle, String imageTitle) throws ImageGSException {
        String captionTitleStr = "BufferedImage\ub97c \ubcf4\uc5ec\uc90d\ub2c8\ub2e4.";
        if (captionTitle != null) {
            captionTitleStr = captionTitle;
        }
        String imageTitleStr = "";
        if (imageTitle != null) {
            imageTitleStr = imageTitle;
        }
        try {
            BufferedImage bis = TChannelViewer.setBufferedImage(bi, imageTitle);
            ImagePanel ip = new ImagePanel(bis);
            JFrame fr = new JFrame(captionTitle);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
        }
        catch (Exception e) {
            throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
        }
    }

    protected static BufferedImage makeBufferedImage(Object obj_grayChannel, String imageTitle) throws ImageGSException {
        if (obj_grayChannel == null) {
            return null;
        }
        short[][] grayChannel = null;
        if (obj_grayChannel instanceof short[][]) {
            grayChannel = CopyIMGBuf.CopyShortGrayIMGBuf((short[][])obj_grayChannel);
        } else if (obj_grayChannel instanceof double[][]) {
            grayChannel = TypeConv2GrayIMG.Double2ShortGrayIMG((double[][])obj_grayChannel);
        }
        int marginLength = 10;
        int textMarginLength = 20;
        short backgroundValue = 128;
        int fontSize = 12;
        String fontName = "\uad74\ub9bc\uccb4";
        short[][] newGrayChannel = null;
        int resizeHeight = 0;
        int resizeWidth = 0;
        BufferedImage bi = null;
        int height = GetSizeIMG.getHeight(grayChannel);
        int width = GetSizeIMG.getWidth(grayChannel);
        if (imageTitle == null || imageTitle.length() < 1) {
            resizeHeight = height + marginLength;
            resizeWidth = width + marginLength;
            newGrayChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight, resizeWidth);
            int i = marginLength;
            while (i < height) {
                int j = marginLength;
                while (j < width) {
                    newGrayChannel[i][j] = grayChannel[i][j];
                    ++j;
                }
                ++i;
            }
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.gray(newGrayChannel);
            bi = cb.getBufferedImage();
        } else {
            resizeHeight = height + marginLength;
            resizeWidth = width + marginLength;
            int resizeHeight2 = resizeHeight + textMarginLength;
            int resizeWidth2 = resizeWidth;
            newGrayChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight2, resizeWidth2);
            int i = marginLength;
            while (i < height) {
                int j = marginLength;
                while (j < width) {
                    newGrayChannel[i][j] = grayChannel[i][j];
                    ++j;
                }
                ++i;
            }
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.gray(newGrayChannel);
            bi = cb.getBufferedImage();
            Graphics2D gp = bi.createGraphics();
            Font fnt = new Font(fontName, 0, fontSize);
            gp.setFont(fnt);
            gp.setColor(Color.BLACK);
            gp.drawString(imageTitle, marginLength, resizeHeight2 - textMarginLength / 2);
            gp.dispose();
        }
        return bi;
    }

    protected static BufferedImage makeBufferedImage(Object obj_redChannel, Object obj_greenChannel, Object obj_blueChannel, String imageTitle) throws ImageGSException {
        if (obj_redChannel == null || obj_greenChannel == null || obj_blueChannel == null) {
            return null;
        }
        short[][] redChannel = null;
        short[][] greenChannel = null;
        short[][] blueChannel = null;
        if (obj_redChannel instanceof short[][]) {
            redChannel = CopyIMGBuf.CopyShortGrayIMGBuf((short[][])obj_redChannel);
        } else if (obj_redChannel instanceof double[][]) {
            redChannel = TypeConv2GrayIMG.Double2ShortGrayIMG((double[][])obj_redChannel);
        }
        if (obj_greenChannel instanceof short[][]) {
            greenChannel = CopyIMGBuf.CopyShortGrayIMGBuf((short[][])obj_greenChannel);
        } else if (obj_greenChannel instanceof double[][]) {
            greenChannel = TypeConv2GrayIMG.Double2ShortGrayIMG((double[][])obj_greenChannel);
        }
        if (obj_blueChannel instanceof short[][]) {
            blueChannel = CopyIMGBuf.CopyShortGrayIMGBuf((short[][])obj_blueChannel);
        } else if (obj_blueChannel instanceof double[][]) {
            blueChannel = TypeConv2GrayIMG.Double2ShortGrayIMG((double[][])obj_blueChannel);
        }
        int marginLength = 10;
        int textMarginLength = 20;
        short backgroundValue = 128;
        int fontSize = 12;
        String fontName = "\uad74\ub9bc\uccb4";
        short[][] newRedChannel = null;
        short[][] newGreenChannel = null;
        short[][] newBlueChannel = null;
        int resizeHeight = 0;
        int resizeWidth = 0;
        BufferedImage bi = null;
        int height = GetSizeIMG.getHeight(redChannel);
        int width = GetSizeIMG.getWidth(redChannel);
        if (imageTitle == null || imageTitle.length() < 1) {
            resizeHeight = height + marginLength;
            resizeWidth = width + marginLength;
            newRedChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight, resizeWidth);
            newGreenChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight, resizeWidth);
            newBlueChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight, resizeWidth);
            int i = marginLength;
            while (i < height) {
                int j = marginLength;
                while (j < width) {
                    newRedChannel[i][j] = redChannel[i][j];
                    newGreenChannel[i][j] = greenChannel[i][j];
                    newBlueChannel[i][j] = blueChannel[i][j];
                    ++j;
                }
                ++i;
            }
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.color(newRedChannel, newGreenChannel, newBlueChannel);
            bi = cb.getBufferedImage();
        } else {
            resizeHeight = height + marginLength;
            resizeWidth = width + marginLength;
            int resizeHeight2 = resizeHeight + textMarginLength;
            int resizeWidth2 = resizeWidth;
            newRedChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight2, resizeWidth2);
            newGreenChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight2, resizeWidth2);
            newBlueChannel = FillIMGBuf.FillShortGrayIMGBuf(backgroundValue, resizeHeight2, resizeWidth2);
            int i = marginLength;
            while (i < height) {
                int j = marginLength;
                while (j < width) {
                    newRedChannel[i][j] = redChannel[i][j];
                    newGreenChannel[i][j] = greenChannel[i][j];
                    newBlueChannel[i][j] = blueChannel[i][j];
                    ++j;
                }
                ++i;
            }
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.color(newRedChannel, newGreenChannel, newBlueChannel);
            bi = cb.getBufferedImage();
            Graphics2D gp = bi.createGraphics();
            Font fnt = new Font(fontName, 0, fontSize);
            gp.setFont(fnt);
            gp.setColor(Color.BLACK);
            gp.drawString(imageTitle, marginLength, resizeHeight2 - textMarginLength / 2);
            gp.dispose();
        }
        return bi;
    }

    protected static BufferedImage setBufferedImage(BufferedImage bi, String imageTitle) throws ImageGSException {
        if (bi == null) {
            return null;
        }
        BufferedImage2Channel bc = new BufferedImage2Channel();
        bc.color(bi);
        short[][] redChannel = bc.getRedChannel();
        short[][] greenChannel = bc.getGreenChannel();
        short[][] blueChannel = bc.getBlueChannel();
        return TChannelViewer.makeBufferedImage(redChannel, greenChannel, blueChannel, imageTitle);
    }
}

