/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.BinaryProc.Binary2GrayIMG;
import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.BufferedImage2Channel;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.ImagePanel;
import com.conv2.imageGS.IMGFileIO.TChannelViewer;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitMaskBuf;
import com.conv2.imageGS.Util.TypeConv2GrayIMG;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class TMultiChannelViewer
extends JFrame {
    private int heightCnt = 0;
    private int widthCnt = 0;
    private int maxDisplayCnt_height = 3;
    private int maxDisplayCnt_width = 3;
    private ImageInfo[][] displayImage = null;

    public TMultiChannelViewer() throws ImageGSException {
        this.init(this.maxDisplayCnt_height, this.maxDisplayCnt_width);
    }

    public TMultiChannelViewer(int heightCnt, int widthCnt) throws ImageGSException {
        this.setHeightMaxDisplayCnt(heightCnt);
        this.setWidthMaxDisplayCnt(widthCnt);
        this.init(heightCnt, widthCnt);
    }

    private void init(int heightCnt, int widthCnt) throws ImageGSException {
        if (heightCnt < 0 || widthCnt < 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightCnt  or widthCnt < 0 ?) ");
        }
        if (heightCnt > this.maxDisplayCnt_height) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " " + this.maxDisplayCnt_height + " limit by imageGS API ");
        }
        if (widthCnt > this.maxDisplayCnt_width) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " " + this.maxDisplayCnt_width + " limit by imageGS API ");
        }
        this.displayImage = null;
        this.displayImage = new ImageInfo[heightCnt][];
        int i = 0;
        while (i < heightCnt) {
            this.displayImage[i] = new ImageInfo[widthCnt];
            ++i;
        }
        i = 0;
        while (i < heightCnt) {
            int j = 0;
            while (j < widthCnt) {
                this.displayImage[i][j] = new ImageInfo(null, 0, 0, false);
                ++j;
            }
            ++i;
        }
        this.heightCnt = heightCnt;
        this.widthCnt = widthCnt;
    }

    public int getHeightMaxDisplayCnt() {
        return this.maxDisplayCnt_height;
    }

    public int getWidthMaxDisplayCnt() {
        return this.maxDisplayCnt_width;
    }

    public void setHeightMaxDisplayCnt(int maxDisplayCnt_height) {
        this.maxDisplayCnt_height = maxDisplayCnt_height;
    }

    public void setWidthMaxDisplayCnt(int maxDisplayCnt_width) {
        this.maxDisplayCnt_width = maxDisplayCnt_width;
    }

    public int getHeightCnt() {
        return this.heightCnt;
    }

    public int getWidthCnt() {
        return this.widthCnt;
    }

    public void setPosition(int heightPos, int widthPos, short[][] channel, boolean binaryFlag) throws ImageGSException {
        this.setPosition(heightPos, widthPos, channel, binaryFlag, (String)null);
    }

    public void setPosition(int heightPos, int widthPos, short[][] channel, boolean binaryFlag, String imageTitle) throws ImageGSException {
        if (heightPos < 0 || widthPos < 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightPos  or widthPos < 0 ?) ");
        }
        if (heightPos >= this.heightCnt || widthPos >= this.widthCnt) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightPos >= " + this.heightCnt + " or widthPos >= " + this.widthCnt + " !) ");
        }
        if (channel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "channel is null!");
        }
        if (this.displayImage[heightPos][widthPos]._exist) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "already register this room!!!");
        }
        if (imageTitle == null || imageTitle.equals("")) {
            imageTitle = "                     ";
        }
        BufferedImage bi = null;
        bi = binaryFlag ? TChannelViewer.makeBufferedImage(Binary2GrayIMG.ShortBinary2GrayIMG((short[][])channel), imageTitle) : TChannelViewer.makeBufferedImage(channel, imageTitle);
        this.displayImage[heightPos][widthPos] = new ImageInfo(bi, bi.getHeight(), bi.getWidth(), true);
    }

    public void setPosition(int heightPos, int widthPos, double[][] channel, boolean binaryFlag, String imageTitle) throws ImageGSException {
        this.setPosition(heightPos, widthPos, TypeConv2GrayIMG.Double2ShortGrayIMG(channel), binaryFlag, imageTitle);
    }

    public void setPosition(int heightPos, int widthPos, short[][] grayChannel) throws ImageGSException {
        this.setPosition(heightPos, widthPos, grayChannel, false, (String)null);
    }

    public void setPosition(int heightPos, int widthPos, short[][] grayChannel, String imageTitle) throws ImageGSException {
        this.setPosition(heightPos, widthPos, grayChannel, false, imageTitle);
    }

    public void setPosition(int heightPos, int widthPos, double[][] grayChannel, String imageTitle) throws ImageGSException {
        this.setPosition(heightPos, widthPos, grayChannel, false, imageTitle);
    }

    public void setPosition(int heightPos, int widthPos, BufferedImage bi) throws ImageGSException {
        this.setPosition(heightPos, widthPos, bi, null);
    }

    public void setPosition(int heightPos, int widthPos, BufferedImage bi, String imageTitle) throws ImageGSException {
        if (heightPos < 0 || widthPos < 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightPos  or widthPos < 0 ?) ");
        }
        if (heightPos >= this.heightCnt || widthPos >= this.widthCnt) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightPos >= " + this.heightCnt + " or widthPos >= " + this.widthCnt + " !) ");
        }
        if (bi == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "bi is null!");
        }
        if (this.displayImage[heightPos][widthPos]._exist) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "already register this room!!!");
        }
        if (imageTitle == null || imageTitle.equals("")) {
            imageTitle = "                     ";
        }
        BufferedImage bis = TChannelViewer.setBufferedImage(bi, imageTitle);
        this.displayImage[heightPos][widthPos] = new ImageInfo(bis, bis.getHeight(), bis.getWidth(), true);
    }

    public void setPosition(int heightPos, int widthPos, short[][] redChannel, short[][] greenChannel, short[][] blueChannel) throws ImageGSException {
        this.setPosition(heightPos, widthPos, redChannel, greenChannel, blueChannel, (String)null);
    }

    public void setPosition(int heightPos, int widthPos, short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String imageTitle) throws ImageGSException {
        if (heightPos < 0 || widthPos < 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightPos  or widthPos < 0 ?) ");
        }
        if (heightPos >= this.heightCnt || widthPos >= this.widthCnt) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The range of the value don't satisify" + " (heightPos >= " + this.heightCnt + " or widthPos >= " + this.widthCnt + " !) ");
        }
        if (redChannel == null || greenChannel == null || blueChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "channel is null!");
        }
        if (imageTitle == null || imageTitle.equals("")) {
            imageTitle = "         ";
        }
        int height = GetSizeIMG.getHeight(redChannel);
        int width = GetSizeIMG.getWidth(redChannel);
        if (this.displayImage[heightPos][widthPos]._exist) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "already register this room!!!");
        }
        BufferedImage bi = TChannelViewer.makeBufferedImage(redChannel, greenChannel, blueChannel, imageTitle);
        this.displayImage[heightPos][widthPos] = new ImageInfo(bi, bi.getHeight(), bi.getWidth(), true);
    }

    public void setPosition(int heightPos, int widthPos, double[][] redChannel, double[][] greenChannel, double[][] blueChannel) throws ImageGSException {
        this.setPosition(heightPos, widthPos, TypeConv2GrayIMG.Double2ShortGrayIMG(redChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(greenChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(blueChannel), (String)null);
    }

    public void setPosition(int heightPos, int widthPos, double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String imageTitle) throws ImageGSException {
        this.setPosition(heightPos, widthPos, TypeConv2GrayIMG.Double2ShortGrayIMG(redChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(greenChannel), TypeConv2GrayIMG.Double2ShortGrayIMG(blueChannel), imageTitle);
    }

    public void run(String title) throws ImageGSException {
        String title_str = null;
        title_str = title == null ? "\ubb34\uc81c" : title;
        try {
            BufferedImage bi = this.getOneBufferedImage();
            ImagePanel ip = new ImagePanel(bi);
            JFrame fr = new JFrame(title);
            fr.getContentPane().add((Component)ip, "Center");
            fr.pack();
            fr.setVisible(true);
            bi = null;
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        BufferedImage bi = null;
        try {
            bi = this.getOneBufferedImage();
        }
        catch (ImageGSException e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
        return bi;
    }

    private BufferedImage getOneBufferedImage() throws ImageGSException {
        int j;
        int all_height = 0;
        int all_width = 0;
        int tmp_all_height1 = 0;
        int tmp_all_height2 = 0;
        int tmp_all_width = 0;
        int current_height = 0;
        int current_width = 0;
        short[][] displayRedIMGBuf = null;
        short[][] displayGreenIMGBuf = null;
        short[][] displayBlueIMGBuf = null;
        short[][] tmpRedIMGBuf = null;
        short[][] tmpGreenIMGBuf = null;
        short[][] tmpBlueIMGBuf = null;
        BufferedImage2Channel bc = new BufferedImage2Channel();
        int i = 0;
        while (i < this.heightCnt) {
            tmp_all_width = 0;
            j = 0;
            while (j < this.widthCnt) {
                if (this.displayImage[i][j]._exist) {
                    tmp_all_height1 = this.displayImage[i][j]._height;
                    tmp_all_width += this.displayImage[i][j]._width;
                } else {
                    bc = null;
                    this.displayImage = null;
                    throw new ImageGSException("Empty!! Please.. fill up room for image display ");
                }
                if (tmp_all_height1 > tmp_all_height2) {
                    tmp_all_height2 = tmp_all_height1;
                }
                ++j;
            }
            if (tmp_all_width > all_width) {
                all_width = tmp_all_width;
            }
            all_height += tmp_all_height2;
            ++i;
        }
        displayRedIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
        displayGreenIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
        displayBlueIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
        i = 0;
        while (i < this.heightCnt) {
            j = 0;
            while (j < this.widthCnt) {
                bc.color(this.displayImage[i][j]._bi);
                tmpRedIMGBuf = bc.getRedChannel();
                tmpGreenIMGBuf = bc.getGreenChannel();
                tmpBlueIMGBuf = bc.getBlueChannel();
                tmp_all_height1 = this.displayImage[i][j]._height;
                int m = 0;
                while (m < this.displayImage[i][j]._height) {
                    int n = 0;
                    while (n < this.displayImage[i][j]._width) {
                        displayRedIMGBuf[m + current_height][n + current_width] = tmpRedIMGBuf[m][n];
                        displayGreenIMGBuf[m + current_height][n + current_width] = tmpGreenIMGBuf[m][n];
                        displayBlueIMGBuf[m + current_height][n + current_width] = tmpBlueIMGBuf[m][n];
                        ++n;
                    }
                    ++m;
                }
                current_width += this.displayImage[i][j]._width;
                if (tmp_all_height1 > tmp_all_height2) {
                    tmp_all_height2 = tmp_all_height1;
                }
                ++j;
            }
            current_height += tmp_all_height2;
            current_width = 0;
            ++i;
        }
        Channel2BufferedImage cb = new Channel2BufferedImage();
        cb.color(displayRedIMGBuf, displayGreenIMGBuf, displayBlueIMGBuf);
        BufferedImage bi = cb.getBufferedImage();
        return bi;
    }

    private class ImageInfo {
        private int _height = 0;
        private int _width = 0;
        private BufferedImage _bi = null;
        private boolean _exist = false;

        public ImageInfo(BufferedImage bi, int height, int width, boolean exist) {
            this._bi = bi;
            this._height = height;
            this._width = width;
            this._exist = exist;
        }

        public String toString() {
            return null;
        }
    }
}

