/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Util.SystemDate;
import java.io.PrintStream;

public class Debug {
    private static boolean debug_flag = true;
    private String ClassName = null;
    private boolean dateDisplay = true;

    public Debug() {
    }

    public Debug(boolean dateDisplay) {
        this.dateDisplay = dateDisplay;
    }

    public Debug(String ClassName) {
        this.ClassName = ClassName;
    }

    public Debug(Object obj) {
        this.ClassName = obj.getClass().getName();
    }

    public Debug(boolean dateDisplay, String ClassName) {
        this.dateDisplay = dateDisplay;
        this.ClassName = ClassName;
    }

    public Debug(boolean dateDisplay, Object obj) {
        this.dateDisplay = dateDisplay;
        this.ClassName = obj.getClass().getName();
    }

    public void setEnabled() {
        debug_flag = true;
    }

    public boolean isEnabled() {
        return debug_flag;
    }

    public void setDisabled() {
        debug_flag = false;
    }

    public void println(String msg) {
        if (debug_flag && this.ClassName == null) {
            this.println(System.out, msg);
        } else if (debug_flag && this.ClassName != null) {
            this.println(System.out, this.ClassName, msg);
        }
    }

    private void println(PrintStream pstream, String ClassName, String msg) {
        if (this.dateDisplay) {
            pstream.println("[" + SystemDate.getDateString("yyyy-MM-dd HH:mm:ss:SSS") + "] [" + ClassName + "] " + msg);
        } else {
            pstream.println("[" + ClassName + "] " + msg);
        }
    }

    private void println(PrintStream pstream, String msg) {
        if (this.dateDisplay) {
            pstream.println("[" + SystemDate.getDateString("yyyy-MM-dd HH:mm:ss:SSS") + "] " + msg);
        } else {
            pstream.println(msg);
        }
    }
}

