/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.ImageConvert;
import com.conv2.imageGS.Util.ExtFileFilter;
import com.conv2.imageGS.Util.FileOperation;
import java.io.File;

public class BatchImageConvert {
    public static void copy(String src_directory, String dest_directory) throws ImageGSException {
        String[] src_FileList = null;
        File dir = new File(src_directory);
        src_FileList = dir.list();
        int i = 0;
        while (i < src_FileList.length) {
            String src_fname = String.valueOf(src_directory) + File.separator + src_FileList[i];
            String dest_fname = String.valueOf(dest_directory) + File.separator + src_FileList[i];
            FileOperation.copy(src_fname, dest_fname);
            ++i;
        }
    }

    public static void copy(String src_directory, String src_format, String dest_directory, String dest_format) throws ImageGSException {
        String[] src_FileList = null;
        ExtFileFilter nf = new ExtFileFilter(src_format);
        File dir = new File(src_directory);
        src_FileList = dir.list(nf);
        int i = 0;
        while (i < src_FileList.length) {
            String src_fname = String.valueOf(src_directory) + File.separator + src_FileList[i];
            String dest_fname = String.valueOf(dest_directory) + File.separator + BatchImageConvert.getFilename(src_FileList[i]) + dest_format;
            ImageConvert.run(src_fname, dest_fname);
            ++i;
        }
    }

    public static void copy(String src_directory, String dest_directory, String dest_format) throws ImageGSException {
        String[] src_FileList = null;
        File dir = new File(src_directory);
        src_FileList = dir.list();
        int i = 0;
        while (i < src_FileList.length) {
            String src_fname = String.valueOf(src_directory) + File.separator + src_FileList[i];
            String dest_fname = String.valueOf(dest_directory) + File.separator + BatchImageConvert.getFilename(src_FileList[i]) + dest_format;
            ImageConvert.run(src_fname, dest_fname);
            ++i;
        }
    }

    public static void move(String src_directory, String dest_directory, boolean overwrite) throws ImageGSException {
        String[] src_FileList = null;
        File tmp = null;
        File dir = new File(src_directory);
        src_FileList = dir.list();
        int i = 0;
        while (i < src_FileList.length) {
            String src_fname = String.valueOf(src_directory) + File.separator + src_FileList[i];
            tmp = new File(src_fname);
            if (!tmp.isDirectory()) {
                String dest_fname = String.valueOf(dest_directory) + File.separator + src_FileList[i];
                FileOperation.move(src_fname, dest_fname, overwrite);
            }
            ++i;
        }
    }

    public static void move(String src_directory, String src_format, String dest_directory, String dest_format) throws ImageGSException {
        String[] src_FileList = null;
        File tmp = null;
        ExtFileFilter nf = new ExtFileFilter(src_format);
        File dir = new File(src_directory);
        src_FileList = dir.list(nf);
        int i = 0;
        while (i < src_FileList.length) {
            String src_fname = String.valueOf(src_directory) + File.separator + src_FileList[i];
            tmp = new File(src_fname);
            if (!tmp.isDirectory()) {
                String dest_fname = String.valueOf(dest_directory) + File.separator + BatchImageConvert.getFilename(src_FileList[i]) + dest_format;
                ImageConvert.run(src_fname, dest_fname);
                tmp.delete();
            }
            ++i;
        }
    }

    public static void move(String src_directory, String dest_directory, String dest_format) throws ImageGSException {
        String[] src_FileList = null;
        File tmp = null;
        File dir = new File(src_directory);
        src_FileList = dir.list();
        int i = 0;
        while (i < src_FileList.length) {
            String src_fname = String.valueOf(src_directory) + File.separator + src_FileList[i];
            tmp = new File(src_fname);
            if (!tmp.isDirectory()) {
                String dest_fname = String.valueOf(dest_directory) + File.separator + BatchImageConvert.getFilename(src_FileList[i]) + dest_format;
                ImageConvert.run(src_fname, dest_fname);
                tmp.delete();
            }
            ++i;
        }
    }

    private static String getFilename(String filename) {
        int extName_end = filename.lastIndexOf(".");
        return filename.substring(0, extName_end + 1);
    }
}

