/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.IMGFileIO;
import com.conv2.imageGS.IMGFileIO.PGMImage;
import com.conv2.imageGS.IMGFileIO.TMultiChannelViewer;
import java.awt.image.BufferedImage;

public class TIMGViewer {
    private TIMGViewer() {
    }

    public static void run(String fname) throws ImageGSException {
        TIMGViewer.run(fname, fname, fname);
    }

    public static void run(String fname, String captionTitle) throws ImageGSException {
        TIMGViewer.run(fname, captionTitle, captionTitle);
    }

    public static void run(String fname, String captionTitle, String imageTitle) throws ImageGSException {
        String ExtName = "";
        int ExtName_start = fname.lastIndexOf(".");
        ExtName = fname.substring(ExtName_start + 1);
        if (ExtName.length() > 4) {
            throw new ImageGSException("TIMGViewer.run() >> " + fname + " " + "This format is not support.");
        }
        String LowerString = ExtName.toLowerCase();
        if (LowerString.equals("raw")) {
            throw new ImageGSException("TIMGViewer.run() >> " + fname + " not support raw format ");
        }
        TIMGViewer.run(fname, captionTitle, imageTitle, -1, -1);
    }

    public static void run(String fname, String captionTitle, int height, int width) throws ImageGSException {
        TIMGViewer.run(fname, captionTitle, captionTitle, height, width);
    }

    public static void run(String fname, String captionTitle, String imageTitle, int height, int width) throws ImageGSException {
        String ExtName = "";
        int ExtName_start = fname.lastIndexOf(".");
        ExtName = fname.substring(ExtName_start + 1);
        if (ExtName.length() > 4) {
            throw new ImageGSException("TIMGViewer.run() >> " + fname + " " + "This format is not support.");
        }
        String LowerString = ExtName.toLowerCase();
        IMGFileIO img = new IMGFileIO();
        BufferedImage bi = null;
        if (LowerString.equals("ppm") || LowerString.equals("jpg") || LowerString.equals("png") || LowerString.equals("bmp") || LowerString.equals("gif")) {
            img.readFileName(fname);
            bi = img.getBufferedImage();
        } else if (LowerString.equals("pgm")) {
            PGMImage pgmImage = new PGMImage(fname);
            bi = pgmImage.getBufferedImage();
        } else if (LowerString.equals("raw")) {
            img.readRAW(fname, height, width);
            img.readFileName(fname);
            bi = img.getBufferedImage();
        } else {
            throw new ImageGSException("TIMGViewer.run() >> " + fname + " " + "This format is not support.");
        }
        TMultiChannelViewer mcv = new TMultiChannelViewer(1, 1);
        mcv.setPosition(0, 0, bi, imageTitle);
        mcv.run(captionTitle);
    }
}

