/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ClassBrowser {
    private Class cl;

    public ClassBrowser(String str) throws ImageGSException {
        try {
            this.cl = Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            throw new ImageGSException(String.valueOf(this.getClassName()) + ">>" + "This class is not exist!" + " (" + str + ")");
        }
    }

    public ClassBrowser(Object obj) {
        this.cl = obj.getClass();
    }

    public ClassBrowser(Class cl) {
        this.cl = cl;
    }

    public String getModifierName() {
        return String.valueOf(Modifier.toString(this.cl.getModifiers())) + " ";
    }

    public String getClassName() {
        if (this.cl.isInterface()) {
            return String.valueOf(this.cl.getName()) + " ";
        }
        return "class " + this.cl.getName() + " ";
    }

    public String getSuperClassName() {
        if (this.cl.getSuperclass() != null) {
            return "extends " + this.cl.getSuperclass().getName() + " ";
        }
        return "";
    }

    public String getInterfaceNames() {
        StringBuffer sb = new StringBuffer();
        Class<?>[] classes = this.cl.getInterfaces();
        if (classes.length != 0) {
            sb.append("implements ");
            int i = 0;
            while (i < classes.length) {
                if (i + 1 != classes.length) {
                    sb.append(String.valueOf(classes[i].getName()) + ", ");
                } else {
                    sb.append(String.valueOf(classes[i].getName()) + "\n");
                }
                ++i;
            }
            return sb.toString();
        }
        return "  \n";
    }

    public String getConstructorNames() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< Constructors >> \n");
        Constructor<?>[] constructors = this.cl.getConstructors();
        if (constructors.length == 0) {
            sb.append("\t\tNot found constructor that has \"public\" property  \n");
            return sb.toString();
        }
        int i = 0;
        while (i < constructors.length) {
            sb.append("\t\t");
            sb.append(constructors[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String getFieldNames() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< Fields >> \n");
        Field[] fields = this.cl.getFields();
        if (fields.length == 0) {
            sb.append("\t\tNot found field that has \"public\" property  \n");
            return sb.toString();
        }
        int i = 0;
        while (i < fields.length) {
            sb.append("\t\t");
            sb.append(fields[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String getMethodNames() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< Methods >> \n");
        Method[] method = this.cl.getMethods();
        if (method.length == 0) {
            sb.append("\t\tNot found method that has \"public\" property  \n");
            return sb.toString();
        }
        int i = 0;
        while (i < method.length) {
            sb.append("\t\t");
            sb.append(method[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getModifierName());
        sb.append(this.getClassName());
        sb.append(this.getSuperClassName());
        sb.append(this.getInterfaceNames());
        sb.append(this.getConstructorNames());
        sb.append(this.getFieldNames());
        sb.append(this.getMethodNames());
        return sb.toString();
    }
}

