/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.FormatMatch;
import com.conv2.imageGS.Util.PrintfFormat;
import java.io.File;
import java.util.Date;

public class IMGFileInfo {
    private String fname = null;
    private String parentPath = null;
    private String format = null;
    private long lastModifiedTime = -1L;
    private Date lastModifiedDate = null;
    private boolean isApplyImageFormat = false;
    private boolean isExist = false;
    private String absolutePath = null;
    private boolean isFile = false;
    private long fileSize = -1L;

    public IMGFileInfo(String fname) throws ImageGSException {
        try {
            this.init(fname);
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e);
        }
    }

    private void init(String fname) throws Exception {
        File fp = new File(fname);
        if (fp.exists() && fp.isDirectory()) {
            this.isFile = false;
        } else if (!fp.exists()) {
            this.isExist = false;
        } else if (fp.exists()) {
            this.isFile = true;
            this.isExist = true;
            this.fname = fp.getName();
            this.parentPath = fp.getParent();
            this.absolutePath = fp.getAbsolutePath();
            this.lastModifiedTime = fp.lastModified();
            this.lastModifiedDate = new Date(fp.lastModified());
            FormatMatch formatCheck = new FormatMatch();
            int formatType = formatCheck.match(fname);
            switch (formatType) {
                case 1: {
                    this.format = "JPEG";
                    break;
                }
                case 2: {
                    this.format = "BMP";
                    break;
                }
                case 3: {
                    this.format = "PPM";
                }
                case 4: {
                    this.format = "PNG";
                    break;
                }
                case 5: {
                    this.format = "GIF";
                    break;
                }
                case -1: {
                    this.format = "UNKNOWN FOMRAT or RAW?";
                }
            }
            if (formatType != -1) {
                this.isApplyImageFormat = true;
            }
            this.fileSize = fp.length();
            fp = null;
        }
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFname() {
        return this.fname;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isApplyImageFormat() {
        return this.isApplyImageFormat;
    }

    public boolean isExist() {
        return this.isExist;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer _buffer = new StringBuffer();
        if (!this.isExist()) {
            _buffer.append(String.valueOf(this.getAbsolutePath()) + " is not exists!");
            return _buffer.toString();
        }
        PrintfFormat _pf = new PrintfFormat("[%2s]  %-20s : %s\n");
        Object[] format = new String[3];
        _buffer.append("==============================================================\n");
        _buffer.append("\t\t Information by imageGS java API  \n");
        _buffer.append("==============================================================\n");
        format[0] = "1";
        format[1] = "fname";
        format[2] = this.getFname();
        _buffer.append(_pf.sprintf(format));
        format[0] = "2";
        format[1] = "absolute path";
        format[2] = this.getAbsolutePath();
        _buffer.append(_pf.sprintf(format));
        format[0] = "3";
        format[1] = "parent path";
        format[2] = this.getParentPath();
        _buffer.append(_pf.sprintf(format));
        format[0] = "4";
        format[1] = "isExist";
        format[2] = String.valueOf(this.isExist());
        _buffer.append(_pf.sprintf(format));
        format[0] = "5";
        format[1] = "isFile";
        format[2] = String.valueOf(this.isFile());
        _buffer.append(_pf.sprintf(format));
        format[0] = "6";
        format[1] = "lastModified(long)";
        format[2] = String.valueOf(this.getLastModifiedTime());
        _buffer.append(_pf.sprintf(format));
        format[0] = "7";
        format[1] = "lastModified(date)";
        format[2] = String.valueOf(this.getLastModifiedDate());
        _buffer.append(_pf.sprintf(format));
        format[0] = "8";
        format[1] = "format";
        format[2] = this.getFormat();
        _buffer.append(_pf.sprintf(format));
        format[0] = "9";
        format[1] = "isApplayImageFormat";
        format[2] = String.valueOf(this.isApplyImageFormat());
        _buffer.append(_pf.sprintf(format));
        format[0] = "10";
        format[1] = "size";
        format[2] = String.valueOf(String.valueOf(this.getFileSize())) + " bytes";
        _buffer.append(_pf.sprintf(format));
        _buffer.append("==============================================================\n");
        return _buffer.toString();
    }
}

