/**
 * Class Name	: Channel2BufferedImage
 * Description	: ä , 2 ۸ Java2D BufferedImage  ȯ 
 * Date 				: 2002/10/31
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/31 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.awt.image.*;

/**
 * ä , 2 ۸ Java2D BufferedImage  ȯ.
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class Channel2BufferedImage 
{
	private int alpha = (int)0xFF000000;
	private BufferedImage bi;	
	
	/**
	 * 
	 */
	public Channel2BufferedImage() 
	{
		this.bi = null;
	}

	/**
	 * ϵ  ä BufferedImage ȯ.
	 * 
	 * @param grayChannel	ϵ  ä
	 * @exception ImageGSException grayChannel ũ⸦    
	 */
	public void gray(short[][] grayChannel) throws ImageGSException
	{
		int height = GetSizeIMG.getHeight(grayChannel);
		int width = GetSizeIMG.getWidth(grayChannel);
		
		gray(grayChannel, height, width);
	}

	/**
	 * ϵ  ä BufferedImage ȯ.
	 * 
	 * @param grayChannel	ϵ  ä
	 * @param height 
	 * @param width ʺ 
	 */
	public void gray(short[][] grayChannel, int height, int width)
	{
		color(grayChannel, grayChannel, grayChannel, height, width);
	}

	/**
	 * Red, Green, Blue ä BufferedImage ȯ.<p>
	 * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * ) HSI, CMY etc<p>
	 * 
	 * @param	RedChannel	Red channel
	 * @param	GreenChannel	Green channel
	 * @param	BlueChannel	Blue channel
	 * @exception ImageGSException  Channel ũ⸦    , ġ  
	 */
	public void color(short[][] RedChannel, short[][] GreenChannel, short [][] BlueChannel) throws ImageGSException
	{
		int red_height = GetSizeIMG.getHeight(RedChannel);
		int red_width = GetSizeIMG.getWidth(RedChannel);

		int green_height = GetSizeIMG.getHeight(GreenChannel);
		int green_width = GetSizeIMG.getWidth(GreenChannel);

		int blue_height = GetSizeIMG.getHeight(BlueChannel);
		int blue_width = GetSizeIMG.getWidth(BlueChannel);
		
		if(red_height != green_height || green_height != blue_height)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORNOTEQUALSIZEOFCHANNELS );	
		}
				
		color(RedChannel, GreenChannel, BlueChannel, red_height, red_width);
	}

	/**
	 * Red, Green, Blue ä BufferedImage ȯ.<p>
	 * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * ) HSI, CMY etc<p>
	 * 
	 * @param	RedChannel	Red channel
	 * @param	GreenChannel	Green channel
	 * @param	BlueChannel	Blue channel
	 * @param	height	
	 * @param	width	ʺ
	 * @exception ImageGSException  Channel ũ⸦    , ġ  
	 */		
	public void color(short[][] RedChannel, short[][] GreenChannel, short [][] BlueChannel, int height, int width)
	{
		int i, j;
		short r, g, b;
			
		try 
		{
			bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB); 	
			
			// BufferedImage ٲ۴.
			for(i=0; i<height; i++)
			{
				for(j=0; j<width; j++)
				{
					r = RedChannel[i][j];
					g = GreenChannel[i][j];
					b = BlueChannel[i][j];
					bi.setRGB(j,i,packRGB(r,g,b));	
				}	
			}
		} 
		catch (Exception e) 
		{
			// igonre	
		}	
	}
	
	/**
	 * ȯ BufferedImage ȯѴ.
	 */
	public BufferedImage getBufferedImage()
					throws ImageGSException
	{
		if(bi == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORBUFFEREDIMAGEISNULL );	
		}
		return bi;	
	}
	
	private  int packRGB(short r, short g, short b) 
	{
		return alpha + 65536*r + 256*g + b;
	}
}
