/**
 * Class Name	: IMGViewer
 * Description	: ش  ÷
 * Date 				: 2002/10/09
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/09 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ش  Ȯڸ ľϿ  PPMViewer / JPEGViewer / PNGViewer / BMPViewer / GIFViewer / PGMViewer  ְ Ѵ.<p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class IMGViewer
{
	private IMGViewer() {}

   /**
     * PPMViewer / JPEGViewer / PNGViewer/ BMPViewer / GIF Viewer  ȣ. <p>
     * , ĸǹٿ fname θ .
     * 
	 * @param	fname	ش  θ
     * @exception ImageGSException 
     */		
	public static void run(String fname) throws ImageGSException
	{
		run(fname, fname);
	}
	
   /**
     * PPMViewer / JPEGViewer / PNGViewer / BMPViewer / GIF Viewer ȣ. <p>
     * 
	 * ,  color type ӿ Ѵ. <p>
	 * 
	 * @param	fname	ش  θ
     * @param    title		(ĸ)
     * @exception ImageGSException 
     */	
	public static void run(String fname, String title) throws ImageGSException
	{
		// fname  Ȯڸ ľѴ.
		int ExtName_start; // Ȯڸ ۵Ǵ ġ
		String ExtName="";

		// Ȯڸ ν
		ExtName_start = fname.lastIndexOf(".");
		ExtName = fname.substring(ExtName_start+1);

		if( ExtName.length() > 4) 
		{
			throw new ImageGSException("IMGViewer.run() >> " + fname 
				+ " " + ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}

		String LowerString = null;

		// ҹڷ ٲپش.
		LowerString = ExtName.toLowerCase();

		if(LowerString.equals("ppm"))
		{
			PPMViewer.run(fname, title);
		}
		else if(LowerString.equals("jpg"))
		{
			JPEGViewer.run(fname, title);	
		}
		else if(LowerString.equals("png"))
		{
			PNGViewer.run(fname, title);	
		}
		else if(LowerString.equals("bmp"))
		{
			BMPViewer.run(fname, title);	
		}
		else if(LowerString.equals("gif"))
		{
			GIFViewer.run(fname, title);	
		}
		else if(LowerString.equals("pgm"))
		{
			PGMViewer.run(fname, title);
		}
		else 
		{
			throw new ImageGSException("IMGViewer.run() >> " + fname 
				 + " " + ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}		
	}

	/**
	  * PPMViewer / JPEGViewer / PNGViewer / BMPViewer / GIF Viewer / PGMViewr / RAWViewer ȣ. <p>
	  * 
	  * ,  color type ӿ ϰ, height, width  RAW view  ʿϸ  ǹϴ. <p>
	  * 
	  * @param	fname	ش  θ
      * @param    title		(ĸ)
      * @param	height	ش   (only raw)
      * @param	width	ش  ʺ (only raw)
	  * @exception ImageGSException 
	  */	
	public static void run(String fname, String title, int height, int width) throws ImageGSException
	{
		// fname  Ȯڸ ľѴ.
		int ExtName_start; // Ȯڸ ۵Ǵ ġ
		String ExtName="";

		// Ȯڸ ν
		ExtName_start = fname.lastIndexOf(".");
		ExtName = fname.substring(ExtName_start+1);

		if( ExtName.length() > 4) 
		{
			throw new ImageGSException("IMGViewer.run() >> " + fname 
				+ " " + ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}

		String LowerString = null;

		// ҹڷ ٲپش.
		LowerString = ExtName.toLowerCase();

		if(LowerString.equals("ppm"))
		{
			PPMViewer.run(fname, title);
		}
		else if(LowerString.equals("jpg"))
		{
			JPEGViewer.run(fname, title);	
		}
		else if(LowerString.equals("png"))
		{
			PNGViewer.run(fname, title);	
		}
		else if(LowerString.equals("bmp"))
		{
			BMPViewer.run(fname, title);	
		}
		else if(LowerString.equals("gif"))
		{
			GIFViewer.run(fname, title);	
		}
		else if(LowerString.equals("pgm"))
		{
			PGMViewer.run(fname, title);
		}
		else if(LowerString.equals("raw"))
		{
			RAWViewer.run(fname, title, height, width);	
		}
		else 
		{
			throw new ImageGSException("IMGViewer.run() >> " + fname 
				+ " " + ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}		
	}
}
