/**
 * Class Name	: ImagePannel
 * Description	: ChannelViewer  Pannel.
 * Date 				: 2002/10/30
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/30 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;

/**
 * A JPanel that contains and draws the gray or color channels.
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */

public class ImagePanel extends JPanel implements MouseListener
{

	private BufferedImage image;

	public ImagePanel(BufferedImage image) {
		this.image = image;
		this.addMouseListener(this);
	}

	public void setBufferedImage(BufferedImage img)
	{
		image = img;
		repaint();
	}

	public Dimension getPreferredSize() {
		return new Dimension(image.getWidth(), image.getHeight());
	}

	public void paintComponent(Graphics g) {
		
		//paint background
		super.paintComponent(g); 

		//Draw image at its natural size
		g.drawImage(image, 0, 0, getWidth(), getHeight(), this);
	}

	// The mouse listener interface
	
	public void mouseClicked(MouseEvent e) {
		int imgx = e.getX()*image.getWidth()/this.getWidth();
		int imgy = e.getY()*image.getHeight()/this.getHeight();
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mousePressed(MouseEvent e) {
	}

	public void mouseReleased(MouseEvent e) {
	}
}
