package com.conv2.imageGS.IMGFileIO.JAI;

/*
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * -Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer.
 *
 * -Redistribution in binary form must reproduct the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that Software is not designed,licensed or intended for use in 
 * the design, construction, operation or maintenance of any nuclear facility.
 */

/**
 * An instance of <code>ImageEncodeParam</code> for encoding images in
 * the BMP format.
 *
 * <p> This class allows for the specification of various parameters
 * while encoding (writing) a BMP format image file.  By default, the
 * version used is VERSION_3, no compression is used, and the data layout
 * is bottom_up, such that the pixels are stored in bottom-up order, the
 * first scanline being stored last. 
 *
 * <p><b> This class is not a committed part of the JAI API.  It may
 * be removed or changed in future releases of JAI.</b>
 * 
 */
public class BMPEncodeParam implements ImageEncodeParam {

    // version constants

    /** Constant for BMP version 2. */
    public static final int VERSION_2 = 0;

    /** Constant for BMP version 3. */
    public static final int VERSION_3 = 1;

    /** Constant for BMP version 4. */
    public static final int VERSION_4 = 2;

    // Default values
    private int version = VERSION_3;
    private boolean compressed = false;
    private boolean topDown = false;
    
    /**
     * Constructs an BMPEncodeParam object with default values for parameters.
     */
    public BMPEncodeParam() {}

    /** Sets the BMP version to be used. */
    public void setVersion(int versionNumber) {
	checkVersion(versionNumber);
	this.version = versionNumber;
    }

    /** Returns the BMP version to be used. */
    public int getVersion() {
	return version;
    }

    /** If set, the data will be written out compressed, if possible. */
    public void setCompressed(boolean compressed) {
	this.compressed = compressed;
    }

    /** 
     * Returns the value of the parameter <code>compressed</code>.
     */
    public boolean isCompressed() {
	return compressed;
    }

    /** 
     * If set, the data will be written out in a top-down manner, the first
     * scanline being written first.
     */
    public void setTopDown(boolean topDown) {
	this.topDown = topDown;
    }

    /**
     * Returns the value of the <code>topDown</code> parameter.
     */
    public boolean isTopDown() {
	return topDown;
    }

    // Method to check whether we can handle the given version.
    private void checkVersion(int versionNumber) {
	if ( !(versionNumber == VERSION_2 ||
	       versionNumber == VERSION_3 ||
	       versionNumber == VERSION_4) ) {
	    throw new RuntimeException(JaiI18N.getString("BMPEncodeParam0")); 
	}
    }

}
