package com.conv2.imageGS.IMGFileIO.JAI;

/*
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * -Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer.
 *
 * -Redistribution in binary form must reproduct the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that Software is not designed,licensed or intended for use in 
 * the design, construction, operation or maintenance of any nuclear facility.
 */

/**
 * An instance of <code>ImageDecodeParam</code> for decoding images in
 * the JPEG format.
 *
 * <p> This class allows for the specification of whether to decode the
 * JPEG data into an image having a <code>SampleModel</code> which is a
 * <code>ComponentSampleModel</code> or a subclass thereof.  By default
 * data are decoded into an image having a <code>ComponentSampleModel</code>.
 *
 * <p><b> This class is not a committed part of the JAI API.  It may
 * be removed or changed in future releases of JAI.</b>
 */
public class JPEGDecodeParam implements ImageDecodeParam {

    /**
     * Flag indicating whether to decode the data into an image with
     * a <code>ComponentSampleModel</code>.
     */
    private boolean decodeToCSM = true;
    
    /**
     * Constructs a <code>JPEGDecodeParam</code> object with default
     * parameter values.
     */
    public JPEGDecodeParam() {
    }

    /**
     * Sets the data formatting flag to the value of the supplied parameter.
     * If <code>true</code> the data will be decoded into an image which has
     * a <code>SampleModel</code> which is a <code>ComponentSampleModel</code>.
     * The default setting of this flag is <code>true</code>.  If the flag is
     * set to <code>false</code> then memory may be saved during decoding but
     * the resulting image is not in that case guaranteed to have a
     * <code>ComponentSampleModel</code>.
     *
     * @param decodeToCSM <code>true</code> if a
     * <code>ComponentSampleModel</code> layout is preferred for the
     * decoded image.
     */
    public void setDecodeToCSM(boolean decodeToCSM) {
        this.decodeToCSM = decodeToCSM;
    }

    /**
     * Returns the value of the <code>ComponentSampleModel</code> flag
     * which is by default <code>true</code>.
     */
    public boolean getDecodeToCSM() {
        return decodeToCSM;
    }
}
