/**
 * Class Name	: Jpeg2Png
 * Description	: JPEG Ÿ ÷  PNG Ÿ ȯ
 * Date 				: 2002/10/25
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/25 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * JPEG Ÿ  PNG  Ÿ  ȯѴ.
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Jpeg2Png
{
	private Jpeg2Png() {}

   /**
     * JPEG  PNG ȯѴ. 
     * 
	 * @param	 jpeg_fname	ȯ JPEG  θ	
     * @return	png_fname	PNG  θ 
     * @exception ImageGSException
     * @exception IOException 
     */
	public static void run(String jpeg_fname, String png_fname) throws ImageGSException
	{
		File fp_src = new File(jpeg_fname);
		
		// ppm   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Jpeg2Png.run() >> " + jpeg_fname + " : " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}

		JPEGImage img = new JPEGImage(jpeg_fname);	
		img.load();
			
		IMGFileIO png = new IMGFileIO();

		short [][] R = img.getRedChannel();
		short [][] G = img.getGreenChannel();
		short [][] B = img.getBlueChannel();		
		int height = img.getHeight();
		int width = img.getWidth();
		
		png.writePNG(png_fname,  R, G, B, height, width);
	}
}
