/**
 * Class Name	: MultiIMGViewer
 * Description	:    display Ѵ.
 * Date 				: 2003/04/05
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/04/05 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.io.*;

/**
 *    ϵ ÷Ѵ. <p>
 * 
 * ַ 2~3    ϴ 쿡 IMGViewer     ִ. <br>
 * ̿ Ͽ     ϰ ִ API̴.<p>
 * 
 * [ ] <p>
 * 
 * 1) ù°<p>
 *  
 *  ũ⿡  ֱ  ©   Ͽ Ѵ.<br>
 *   ũ⶧ ޸𸮰   Ƿ, <br>
 * ڽ  ý ϴѿ Ʒ  ϶.<p>
 * 
 * java -Xms64M -Xmx256M  MultiIMGViewer  (ִ 64ް 256ް ڴٴ )<p>
 * 
 * 2) ι° <p>
 * 
 * ִ ټ ִ  ʰ ʺ  3 Ѵ. <br>
 * ̻ ø  е  ñ Ѵ.<p>
 * 
 * 3) ° <p>
 * 
 *  ȣ   ,   ä Ѵ.<p>
 * 
 * 4) ׹° <p>
 * 
 *     ÷ Ÿ̾ Ѵ.<p>
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class MultiIMGViewer extends JFrame
{
	private int heightCnt = 0;
	private int widthCnt = 0;
		
	private int maxDisplayCnt_height = 3;
	private int maxDisplayCnt_width = 3;
	
	private ImageInfo [][] displayImage = null;		


	/**
	 * 
	 * 
	 */
	public MultiIMGViewer() throws ImageGSException 
	{
		init(this.maxDisplayCnt_height, this.maxDisplayCnt_width);
	}
		
	/**
	 * 
	 * 
	 * @param heightCnt      .
	 * @param widthCnt ʺ     .
	 * @exception heightCnt  widthCnt  ϳ 0   , heightCnt, widthCnt  ʰ Ǿ  
	 */
	public MultiIMGViewer(int heightCnt, int widthCnt) throws ImageGSException 
	{
		this.setHeightMaxDisplayCnt(heightCnt);
		this.setWidthMaxDisplayCnt(widthCnt);
		init(heightCnt, widthCnt);
	}
	
	private void init(int heightCnt, int widthCnt) throws ImageGSException
	{
		if(heightCnt < 0 || widthCnt < 0)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE  + " (heightCnt  or widthCnt < 0 ?) " );
		}
		
		if(heightCnt  > maxDisplayCnt_height) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE  
				+ " " + maxDisplayCnt_height + " limit by imageGS API " );
		}

		if(widthCnt  > maxDisplayCnt_width) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE 
				+ " " + maxDisplayCnt_width + " limit by imageGS API " );
		}

		displayImage = null;
	
		// displayImages ʱȭ
		displayImage = new ImageInfo[heightCnt][];
		
		for(int i=0; i<heightCnt; i++)
		{
			displayImage[i] = new ImageInfo[widthCnt];
		}		

		for(int i=0; i<heightCnt; i++)
		{
			for(int j=0; j<widthCnt; j++)
			{
				displayImage[i][j] = new ImageInfo(null, 0, 0, false);	
			}	
		}
		
		this.heightCnt = heightCnt;
		this.widthCnt = widthCnt;	
	}

	/**
	 *  ִ    ȯѴ.
	 */
	public int getHeightMaxDisplayCnt()
	{
		return this.maxDisplayCnt_height;	
	}
	
	/**
	 * ʺ ִ    ȯѴ.
	 */
	public int getWidthMaxDisplayCnt()
	{
		return this.maxDisplayCnt_width;	
	}

	/**
	 *  ִ    Ѵ.
	 */
	public void setHeightMaxDisplayCnt(int maxDisplayCnt_height)
	{
		this.maxDisplayCnt_height = maxDisplayCnt_height;	
	}
	
	/**
	 * ʺ ִ    Ѵ.
	 */
	public void setWidthMaxDisplayCnt(int maxDisplayCnt_width)
	{
		this.maxDisplayCnt_width = maxDisplayCnt_width;	
	}
	
	/**
	 * ش ä ġ Ѵ. , ù ε 0  Կ Ѵ.
	 * 
	 * @param heightPos ش ä  ġ
	 * @param widthPos ش ä ʺ ġ
	 * @param fname ش  ϸ
	 * @exception fname     , heightPos widthPos  ϳ 0̰ų   ̻ 
	 */
	public void setPosition(int heightPos, int widthPos, String fname) throws ImageGSException
	{
		int height = 0;
		int width = 0;
		BufferedImage bi = null;
		
		if(heightPos < 0 || widthPos < 0)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE  
				+ " (heightPos  or widthPos < 0 ?) " );
		}
		
		if(heightPos >= heightCnt || widthPos >=widthCnt)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE 
				+ " (heightPos >= " + heightCnt + " or widthPos >= " + widthCnt + " !) " );
		}		
		
		if(displayImage[heightPos][widthPos]._exist == true)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ "already register this room!!!" );
		}
		
		// fname ,   üũѴ.		
		if(fname == null) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORUSERVALUEISNULL );	
		}
		else 
		{
			File fp = new File(fname);
			if(fp.exists() == false) 
			{
				throw new ImageGSException(this.getClass().getName() + " >> " 
					+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
			}
		}		

		IMGFileIO gs = new IMGFileIO();
		gs.readFileName(fname);

		height = gs.getHeight();
		width = gs.getWidth();
		bi = gs.getBufferedImage();
		
		// ImageInfo 
		displayImage[heightPos][widthPos] = new ImageInfo(bi, height, width, true);
	}

   /**
     * display Ѵ.  
     * 
     * @return    title		(ĸ)
     * @exception ImageGSException  
     */
	public void run(String title) throws ImageGSException 
	{
		String title_str = null;
					
		if(title == null) title_str = ""; 
		else title_str = title;

		try 
		{
			BufferedImage bi = getBufferedImage();		
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(title);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);
			bi = null;		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("MultiIMGViewer.run() >> " + e.getMessage());
		}
	}	
	
	/**
	 * ϳ BufferedImage ȯѴ.
	 */
	private BufferedImage getBufferedImage() throws ImageGSException
	{
		int i, j;
		int m,n;		
		
		int all_height = 0;
		int all_width = 0;
		int tmp_all_height1 = 0;
		int tmp_all_height2 = 0;
		int tmp_all_width = 0;

		int current_height = 0;
		int current_width = 0;
				
		short[][] displayRedIMGBuf = null;
		short[][] displayGreenIMGBuf = null;
		short[][] displayBlueIMGBuf = null;

		short[][] tmpRedIMGBuf = null;
		short[][] tmpGreenIMGBuf = null;
		short[][] tmpBlueIMGBuf = null;
			
		BufferedImage2Channel bc = new BufferedImage2Channel();
		
		for(i=0; i<heightCnt; i++)
		{
			tmp_all_width = 0;
			
			for(j=0; j<widthCnt; j++)
			{
				if(displayImage[i][j]._exist == true)
				{
					tmp_all_height1 = displayImage[i][j]._height;
					tmp_all_width += displayImage[i][j]._width;		
				}
				else {
					
					bc = null;
					displayImage = null;

					//   ä ϸ  ִٴ  ޽ ش.
					throw new ImageGSException("Empty!! Please.. fill up room for image display ");	
				}
				
				if(tmp_all_height1 > tmp_all_height2) tmp_all_height2 = tmp_all_height1;
			}

			if(tmp_all_width > all_width) all_width = tmp_all_width;
			all_height += tmp_all_height2;
		}
	
		// ޸ Ҵ
		displayRedIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
		displayGreenIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
		displayBlueIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
				
		// ȭҰ  ֱ.	
		// 	
		for(i=0; i<heightCnt; i++)
		{
			for(j=0; j<widthCnt; j++)
			{
				bc.color(displayImage[i][j]._bi);
				tmpRedIMGBuf = bc.getRedChannel();
				tmpGreenIMGBuf = bc.getGreenChannel();
				tmpBlueIMGBuf = bc.getBlueChannel();
				tmp_all_height1 = displayImage[i][j]._height;
				
				for(m=0; m<displayImage[i][j]._height; m++)
				{
					for(n=0; n<displayImage[i][j]._width; n++)
					{
						displayRedIMGBuf[m+current_height][n+current_width] = tmpRedIMGBuf[m][n];	
						displayGreenIMGBuf[m+current_height][n+current_width] = tmpGreenIMGBuf[m][n];	
						displayBlueIMGBuf[m+current_height][n+current_width] = tmpBlueIMGBuf[m][n];		
					}	
				}
				current_width += displayImage[i][j]._width;  
				if(tmp_all_height1 > tmp_all_height2) tmp_all_height2 = tmp_all_height1;
			}
			current_height  += tmp_all_height2;
			current_width = 0;
		}		
		
		// BufferedImage ȯ
		Channel2BufferedImage cb = new Channel2BufferedImage();
		cb.color(displayRedIMGBuf, displayGreenIMGBuf, displayBlueIMGBuf);
		BufferedImage bi = cb.getBufferedImage();
		 		
		return bi;
	}
	
	/**
	 *  ش BufferedImage   Ŭ
	 */
	private class ImageInfo 
	{
		private int _height  = 0;
		private int _width = 0;
		private BufferedImage _bi = null;
		private boolean _exist = false;
		
		public ImageInfo(BufferedImage bi, int height, int width, boolean exist)
		{
			this._bi = bi;
			this._height = height;
			this._width = width;	
			this._exist = exist;
		}
		
		public String toString()
		{
			return null;	
		}	
	}
}