/**
 * Class Name	: RAWGrayImage
 * Description	: gray RAW handling class.
 * Date 				: 2002/11/29
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/29 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.Util.*;

import javax.swing.*;

/**
 * RAW   ó   κ gray level̴.<br>
 * imageGS API color type ϴ , <br>
 * gray Ÿ raw  ٷ    ְ ȴ.<p>
 * 
 * RAW   ó о߿   Ͽ, <br>
 * ڰ gray Ÿ raw  ڵ鸵 ϴ Ŭ Ѵ. <p>
 * 
 * [] IMGFileIO Ŭ  ʴ´. 
 *
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class RAWGrayImage 
{
	//  : RAWImage ҽ   ϳ load(), save() κп ̰ ִ.
	
	private String fname;
	private BufferedImage myBufferedImage = null;
	private short [][] GrayChannel = null;

	private int height = 0;
	private int width = 0;

	protected ImagePanel panel;
	
	
	/**
	 * height, width ݵ ˾ƾ Ѵ. raw    ̴.
	 */
	public RAWGrayImage(String fname, int height, int width) throws ImageGSException
	{
//		File fp = new File(fname);
//		
//		// gray type ƴϸ ܻȲ . , ش ϸ...
//		if(height*width !=  fp.length() && fp.exists())
//		{
//			throw new ImageGSException(this.getClass().getName() + " >> "
//																+ ErrorMsg.ERRORTHISISNOTGRAYIMAGE );				
//		}
				
		this.fname = fname;
		this.height = height;
		this.width = width;
	}
	
	public int getHeight()
	{
		return height;	
	}
	
	public int getWidth()
	{
		return width;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}

	public void load() throws ImageGSException
	{
		FileInputStream in = null;
		int length = 0;	
		int i = 0;
		int j = 0;		
		try 
		{
			in = new FileInputStream(fname);

			GrayChannel = InitIMGBuf.ShortIMGBuf(height, width);
			
			for(i = 0; i < height; i++)
			{
				for(j = 0; j < width; j++)
				{
					GrayChannel[i][j] = (short)in.read();
				}
			}
		
			in.close();
		}
		catch(IOException e)
		{	
			if(in != null) try { in.close(); } catch(IOException se) {}
			
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage() );	
		}	
	}	

	// Get image panel
	public JPanel getImagePanel()
	{
		panel = new ImagePanel(getBufferedImage());	

		return panel;
	}
		
	public BufferedImage getBufferedImage()
	{
		try 
		{
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.gray(GrayChannel, height, width);
			myBufferedImage = cb.getBufferedImage();
		}
		catch (ImageGSException e) 
		{
			; // ignore	
		}
		
		return myBufferedImage;
	}	

	public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutGrayChannel, OutHeight, OutWidth);	
	}
		
	public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException
	{
		int i, j;
		FileOutputStream out = null;
		
		try 
		{
			out = new FileOutputStream(fname);

			// 2 1 .
			for(i=0; i<OutHeight; i++)
			{
				for(j=0; j<OutWidth; j++)
				{
					out.write((byte)OutGrayChannel[i][j]);
				}	
			}
			
			out.close();
		}
		catch(Exception e)
		{
			if(out != null) try { out.close(); } catch(IOException se) {}
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage() );	
		}			
		
	}
}
