/**
 * Class Name	: RAWImage
 * Description	: RAW handling class.
 * Date 				: 2002/11/28
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/28 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.Util.*;
import javax.swing.*;

/**
 * RAW handling Ŭ.<p>
 * 
 * , gray level   JPEG   ÷  Ÿ Ѵ. <br>
 * ׷Ƿ color  Ѵ.<p>
 * 
 * ⼭ RGBRGB...  Ѵ. <p>
 * 
 * [] IMGViewer Ŭ   . <p>
 * [] RAW  <p>
 * - header Ƿ ũ⸦ ˼ . <br>
 * - ؽƮ Ǵ ̳ʸ ̷ ֱ  ϵ/÷ Ÿ   .<br>
 * - ࿡ ÷ Ÿ̶ RGB ΰ? RRRRRRR... GGGGG.. BBBB ΰ   .<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class RAWImage
{
	private String fname;
	private BufferedImage myBufferedImage = null;
	private short [][] RedChannel = null;
	private short [][] GreenChannel = null;
	private short [][] BlueChannel = null;
	private short [][] GrayChannel = null;
	private int alpha = (int)0xFF000000;

	private int height = 0;
	private int width = 0;

	protected ImagePanel panel;
	
	/**
	 * height, width ݵ ˾ƾ Ѵ. raw    ̴.
	 */
	public RAWImage(String fname, int height, int width) throws ImageGSException
	{
		
//		File fp = new File(fname);
//		
//		// color type ƴϸ ܻȲ . , ش ϸ...
//		if(height*width*3 != fp.length() && fp.exists())
//		{
//			throw new ImageGSException(this.getClass().getName() + " >> "
//																+ ErrorMsg.ERRORTHISISNOTCOLORIMAGE );				
//		}
		
		this.fname = fname;
		this.height = height;
		this.width = width;
	}
	
	public int getHeight()
	{
		return height;	
	}
	
	public int getWidth()
	{
		return width;
	}

	public short[][] getRedChannel()
	{
		return (short[][])RedChannel;
	}

	public short[][] getGreenChannel()
	{
		return (short[][])GreenChannel;
	}

	public short[][] getBlueChannel()
	{
		return (short[][])BlueChannel;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}

	public void load() throws ImageGSException
	{
		FileInputStream in = null;
		int length = 0;	
		int i = 0;
		int j = 0;		
		try 
		{
			in = new FileInputStream(fname);
			short r, g, b = -1;
		
			//  Red, Green, Blue channel Ѵ.
			// Red, Green, Blue channel ֱ
			// 迭  ޸ Ҵ.
			RedChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GreenChannel = InitIMGBuf.ShortIMGBuf(height, width);
			BlueChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GrayChannel = InitIMGBuf.ShortIMGBuf(height, width);
			
			for(i = 0; i < height; i++)
			{
				for(j = 0; j < width; j++)
				{
					r = (short)in.read();
					g = (short)in.read();
					b = (short)in.read();
					RedChannel[i][j] = r;
					GreenChannel[i][j] = g;
					BlueChannel[i][j] = b;
					GrayChannel[i][j] =  (short)((float)r*0.299 
													+ (float)g*0.587 
													+ (float)b*0.114);		
				}
			}

		
			in.close();
		}
		catch(IOException e)
		{	
			if(in != null) try { in.close(); } catch(IOException se) {}
			
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage() );	
		}	
	}	

	// Get image panel
	public JPanel getImagePanel()
	{
		panel = new ImagePanel(getBufferedImage());	

		return panel;
	}
		
	public BufferedImage getBufferedImage()
	{
		try 
		{
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.color(RedChannel, GreenChannel, BlueChannel, height, width);
			myBufferedImage = cb.getBufferedImage();
		}
		catch (ImageGSException e) 
		{
			// ignore	
		}
		
		return myBufferedImage;
	}	


	public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutGrayChannel, OutHeight, OutWidth);	
	}
		
	public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException
	{
		this.save(OutGrayChannel, OutGrayChannel, OutGrayChannel, OutHeight, OutWidth);	
	}

	public void save(String OutFname, 
								short[][] OutRedChannel, 
								short[][] OutGreenChannel, 
								short[][] OutBlueChannel, 
								int OutHeight, int OutWidth
								)
		throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutRedChannel, OutGreenChannel, OutBlueChannel, OutHeight, OutWidth);	
	}

	public void save(short[][] OutRedChannel, 
								short[][] OutGreenChannel, 
								short[][] OutBlueChannel, 
								int OutHeight, int OutWidth
								)
		throws ImageGSException
	{
		BufferedImage outputBufferedImage = null;
		short r, g, b;
		int value;
		int i, j;
		FileOutputStream out = null;
		byte rgb[] = new byte[3];
		
		try 
		{
			outputBufferedImage = new BufferedImage(OutWidth,OutHeight, BufferedImage.TYPE_INT_RGB);
			out = new FileOutputStream(fname);
			
			// Write the pixels
			// ڹ  : RAW  Ÿ 
			// 0~255̳, C unsigned char شϴ Ÿ
			// ڹٿ   byte  ؾ ϴ 
			//  츮  ̴   Ʋ.
			// ٸ, ó  ϴ.

			// 2 1 .
			for(i=0; i<OutHeight; i++)
			{
				for(j=0; j<OutWidth; j++)
				{
					r = OutRedChannel[i][j];
					g = OutGreenChannel[i][j];
					b = OutBlueChannel[i][j];
					
					outputBufferedImage.setRGB(j,i,packRGB(r,g,b));	
					value = outputBufferedImage.getRGB(j,i);
					rgb[2] = (byte)(value&0xFF);
					rgb[1] = (byte)((value>>8)&0xFF);
					rgb[0] = (byte)((value>>16)&0xFF);
					
					out.write(rgb);
				}	
			}
			
			out.close();
		}
		catch(Exception e)
		{
			if(out != null) try { out.close(); } catch(IOException se) {}
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage() );	
		}			
		
	}

	private int packRGB(short r, short g, short b) 
	{
		return alpha + 65536*r + 256*g + b;
	 }
}
