/**
 * Class Name	: TMultiChannelViewer
 * Description	: ش ä display Ѵ.
 * Date 				: 2003/10/20
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/20 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

/**
 *   ϵ  ۸ ÷Ѵ. <p>
 * 
 * ַ 2~3    ϴ 쿡 ChannelViewer     ִ. <br>
 * ̿ Ͽ ϵ  ۵ ϰ ִ API̴.<p>
 * 
 *  Ŭ,    display ֺ  ְ, ϴܿ ڸ   ִ.<br>
 * ׷Ƿ, MultiGrayChannelViewer ɰ ϳ, ,  ߰ Ǿٴ 鸸 ٸ. <p>
 * 
 * [ ] <p>
 * 
 * 1) ù°<p>
 *  
 *  ũ⿡  ֱ  ©   Ͽ Ѵ.<br>
 *   ũ⶧ ޸𸮰   Ƿ, <br>
 * ڽ  ý ϴѿ Ʒ  ϶.<p>
 * 
 * java -Xms64M -Xmx256M  MultiChannelViewer  (ִ 64ް 256ް ڴٴ )<p>
 * 
 * 2) ι° <p>
 * 
 * ִ ټ ִ  ʰ ʺ  3 Ѵ. <br>
 * ̻ ø  е  ñ Ѵ.<p>
 * 
 * 3) ° <p>
 * 
 *  ȣ   ,   ä Ѵ.<p>
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class TMultiGrayChannelViewer extends JFrame 
{
	private int heightCnt = 0;
	private int widthCnt = 0;
		
	private int maxDisplayCnt_height = 3;
	private int maxDisplayCnt_width = 3;
	
	private ImageInfo [][] displayImage = null;		
	
	/**
	 * 
	 * 
	 */
	public TMultiGrayChannelViewer() throws ImageGSException 
	{
		init(this.maxDisplayCnt_height, this.maxDisplayCnt_width);
	}
		
	/**
	 * 
	 * 
	 * @param heightCnt      .
	 * @param widthCnt ʺ     .
	 * @exception heightCnt  widthCnt  ϳ 0   , heightCnt, widthCnt  ʰ Ǿ  
	 */
	public TMultiGrayChannelViewer(int heightCnt, int widthCnt) throws ImageGSException 
	{
		this.setHeightMaxDisplayCnt(heightCnt);
		this.setWidthMaxDisplayCnt(widthCnt);
		init(heightCnt, widthCnt);
	}
	
	private void init(int heightCnt, int widthCnt) throws ImageGSException
	{
		if(heightCnt < 0 || widthCnt < 0)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE  + " (heightCnt  or widthCnt < 0 ?) " );
		}
		
		if(heightCnt  > maxDisplayCnt_height) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE  
				+ " " + maxDisplayCnt_height + " limit by imageGS API " );
		}

		if(widthCnt  > maxDisplayCnt_width) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE 
				+ " " + maxDisplayCnt_width + " limit by imageGS API " );
		}

		displayImage = null;
	
		// displayImages ʱȭ
		displayImage = new ImageInfo[heightCnt][];
		
		for(int i=0; i<heightCnt; i++)
		{
			displayImage[i] = new ImageInfo[widthCnt];
		}		

		for(int i=0; i<heightCnt; i++)
		{
			for(int j=0; j<widthCnt; j++)
			{
				displayImage[i][j] = new ImageInfo(null, 0, 0, false);	
			}	
		}
		
		this.heightCnt = heightCnt;
		this.widthCnt = widthCnt;	
	}

	/**
	 *  ִ    ȯѴ.
	 */
	public int getHeightMaxDisplayCnt()
	{
		return this.maxDisplayCnt_height;	
	}
	
	/**
	 * ʺ ִ    ȯѴ.
	 */
	public int getWidthMaxDisplayCnt()
	{
		return this.maxDisplayCnt_width;	
	}

	/**
	 *  ִ    Ѵ.
	 */
	public void setHeightMaxDisplayCnt(int maxDisplayCnt_height)
	{
		this.maxDisplayCnt_height = maxDisplayCnt_height;	
	}
	
	/**
	 * ʺ ִ    Ѵ.
	 */
	public void setWidthMaxDisplayCnt(int maxDisplayCnt_width)
	{
		this.maxDisplayCnt_width = maxDisplayCnt_width;	
	}

	/**
	 * ڰ  ̿ شϴ    ȯѴ.
	 */
	public int getHeightCnt()
	{
		return heightCnt;	
	}
	
	/**
	 * ڰ  ʺ شϴ    ȯѴ.
	 */
	public int getWidthCnt()
	{
		return widthCnt;	
	}

	/**
	 * ش ä ġ Ѵ. , ù ε 0  Կ Ѵ.
	 * 
	 * @param heightPos ش ä  ġ
	 * @param widthPos ش ä ʺ ġ
	 * @param grayChannel short type 2 
	 * @exception grayChannel  , heightPos widthPos  ϳ 0̰ų   ̻ 
	 */
	public void setPosition(int heightPos, int widthPos, short[][] grayChannel) throws ImageGSException
	{
		setPosition(heightPos, widthPos, grayChannel, null);		
	}			
	
	/**
	 * ش ä ġ Ѵ. , ù ε 0  Կ Ѵ.
	 * 
	 * @param heightPos ش ä  ġ
	 * @param widthPos ش ä ʺ ġ
	 * @param grayChannel short type 2 
	 * @param imageTitle ش  ä ؿ  (ĸ)
	 * @exception grayChannel  , heightPos widthPos  ϳ 0̰ų   ̻ 
	 */
	public void setPosition(int heightPos, int widthPos, short[][] grayChannel, String imageTitle ) throws ImageGSException
	{
		
		if(heightPos < 0 || widthPos < 0)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE  
				+ " (heightPos  or widthPos < 0 ?) " );
		}
		
		if(heightPos >= heightCnt || widthPos >=widthCnt)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE 
				+ " (heightPos >= " + heightCnt + " or widthPos >= " + widthCnt + " !) " );
		}		
		
		if(grayChannel == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG);
		}
	
		int height = GetSizeIMG.getHeight(grayChannel);
		int width  = GetSizeIMG.getWidth(grayChannel);

		if(displayImage[heightPos][widthPos]._exist == true)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ "already register this room!!!" );
		}

		// space  ó 
		if(imageTitle == null || imageTitle.equals("") ) imageTitle = "   ";
						
		BufferedImage bi = TChannelViewer.makeBufferedImage(grayChannel, imageTitle);

		// ImageInfo 
		displayImage[heightPos][widthPos] = new ImageInfo(bi, bi.getHeight(), bi.getWidth(), true);
	}

	/**
	 * ش ä ġ Ѵ. , ù ε 0  Կ Ѵ.
	 * 
	 * @param heightPos ش ä  ġ
	 * @param widthPos ش ä ʺ ġ
	 * @param grayChannel double type 2 
	 * @exception grayChannel  , heightPos widthPos  ϳ 0̰ų   ̻ 
	 */
	public void setPosition(int heightPos, int widthPos, double[][] grayChannel) throws ImageGSException
	{
		setPosition(heightPos, widthPos, TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel));
	}

   /**
     * display Ѵ. 
     * 
     * @return    title		(ĸ)
     * @exception ImageGSException  
     */
	public void run(String title) throws ImageGSException 
	{
		String title_str = null;
					
		if(title == null) title_str = ""; 
		else title_str = title;

		try 
		{
			BufferedImage bi = getOneBufferedImage();		
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(title);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);
			bi = null;		
		} 
		catch (Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "  + e.getMessage());
		}
	}	

	/**
	 *   ü BufferedImage Ÿ ȯѴ.
	 * 
	 * @return BufferedImage type object
	 * @throws ImageGSException
	 */
	public BufferedImage getBufferedImage() throws ImageGSException
	{
		BufferedImage bi = null;
		
		try
		{
			bi = getOneBufferedImage();
		}
		catch(ImageGSException e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage());
		}
		
		return bi;
	}
		
	/**
	 * ϳ BufferedImage ȯѴ.
	 */
	private BufferedImage getOneBufferedImage() throws ImageGSException
	{
		int i, j;
		int m,n;		
		
		int all_height = 0;
		int all_width = 0;
		int tmp_all_height1 = 0;
		int tmp_all_height2 = 0;
		int tmp_all_width = 0;

		int current_height = 0;
		int current_width = 0;
				
		short[][] displayIMGBuf = null;
		short[][] tmpIMGBuf = null;
			
		BufferedImage2Channel bc = new BufferedImage2Channel();
		
		for(i=0; i<heightCnt; i++)
		{
			tmp_all_width = 0;
			
			for(j=0; j<widthCnt; j++)
			{
				if(displayImage[i][j]._exist == true)
				{
					tmp_all_height1 = displayImage[i][j]._height;
					tmp_all_width += displayImage[i][j]._width;		
				}
				else {
					
					bc = null;
					displayImage = null;

					//   ä ϸ  ִٴ  ޽ ش.
					throw new ImageGSException("Empty!! Please.. fill up room for gray image display ");	
				}
				if(tmp_all_height1 > tmp_all_height2) tmp_all_height2 = tmp_all_height1;
			}

			if(tmp_all_width > all_width) all_width = tmp_all_width;
			all_height += tmp_all_height2;
		}

		// ޸ Ҵ
		displayIMGBuf = InitMaskBuf.ShortInitMask(all_height, all_width);
				
		// ȭҰ  ֱ.	
		// 	
		for(i=0; i<heightCnt; i++)
		{
			for(j=0; j<widthCnt; j++)
			{
				bc.gray(displayImage[i][j]._bi);
				tmpIMGBuf = bc.getGrayChannel();
				tmp_all_height1 = displayImage[i][j]._height;
				
				for(m=0; m<displayImage[i][j]._height; m++)
				{
					for(n=0; n<displayImage[i][j]._width; n++)
					{
						displayIMGBuf[m+current_height][n+current_width] = tmpIMGBuf[m][n];		
					}	
				}
				current_width += displayImage[i][j]._width;  
				if(tmp_all_height1 > tmp_all_height2) tmp_all_height2 = tmp_all_height1;
			}
			current_height  += tmp_all_height2;
			current_width = 0;
		}		
		
		// BufferedImage ȯ
		Channel2BufferedImage cb = new Channel2BufferedImage();
		cb.gray(displayIMGBuf);
				
		BufferedImage bi = cb.getBufferedImage();
		 		
		return bi;
	}
	
	/**
	 *  ش BufferedImage   Ŭ
	 */
	private class ImageInfo 
	{
		private int _height  = 0;
		private int _width = 0;
		private BufferedImage _bi = null;
		private boolean _exist = false;
		
		public ImageInfo(BufferedImage bi, int height, int width, boolean exist)
		{
			this._bi = bi;
			this._height = height;
			this._width = width;	
			this._exist = exist;
		}
		
		public String toString()
		{
			return null;	
		}	
	}
}