/**
 * Class Name	: Clamping
 * Description	: Ŭ  Ŭ
 * Date 				: 2002/11/02
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/03 first created.
 */

package com.conv2.imageGS.Util;

/**
 * clamping  Wrap Saturation .<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public final class Clamping
{
	/**
	 * 
	 */
	private Clamping() {}

   /**
     * DoubleSaturation : 0 ϴ 0, 255 ̻ 0, argument type integer.
	 *
     * @return    Saturation , double  ȯ
     */
	public static double DoubleSaturation (int var)
	{	
		double retVal;
		
		if(var > 255)
		{
			retVal = 255.0;	
		} 
		else if(var < 0)
		{
			retVal = 0.0;
		}
		else 
		{
			retVal = (double) var;	
		}
		
		return retVal;
	}	

   /**
     * DoubleSaturation : 0 ϴ 0, 255 ̻ 0, argument type double.
	 *
     * @return    Saturation , double  ȯ
     */
	public static double DoubleSaturation (double var)
	{	
		double retVal;
		
		if(var > 255.0)
		{
			retVal = 255.0;	
		} 
		else if(var < 0.0)
		{
			retVal = 0.0;
		}
		else 
		{
			retVal =  var;	
		}
		
		return retVal;
	}	
	
   /**
     * IntSaturation : 0 ϴ 0, 255 ̻ 0,  argument type double.
	 *
     * @return    Saturation , integer  ȯ
     */
	public static int IntSaturation (double var)
	{	
		int retVal;
		
		if(var > 255.0)
		{
			retVal = 255;	
		} 
		else if(var < 0.0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = (int)var;	
		}
		
		return retVal;
	}	

   /**
     * IntSaturation : 0 ϴ 0, 255 ̻ 0, argument type int.
	 *
     * @return    Saturation , integer  ȯ
     */
	public static int IntSaturation (int var)
	{	
		int retVal;
		
		if(var > 255)
		{
			retVal = 255;	
		} 
		else if(var < 0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = var;	
		}
		
		return retVal;
	}	

   /**
     * SaturationWrap : 0 ϴ 0, 255 ̻ 0,  argument type double.
	 *
     * @return    Saturation , short  ȯ
     */
	public static short ShortSaturation (double var)
	{	
		short retVal;
		
		if(var > 255.0)
		{
			retVal = 255;	
		} 
		else if(var < 0.0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = (short)var;	
		}
		
		return retVal;
	}	

   /**
     * ShortSaturation : 0 ϴ 0, 255 ̻ 0,  argument type int.
	 *
     * @return    Saturation , short  ȯ
     */
	public static short ShortSaturation (int var)
	{	
		short retVal;
		
		if(var > 255)
		{
			retVal = 255;	
		} 
		else if(var < 0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = (short)var;	
		}
		
		return retVal;
	}	

   /**
     * ShortSaturation : 0 ϴ 0, 255 ̻ 0,  argument type short.
	 *
     * @return    Saturation , short  ȯ
     */
	public static short ShortSaturation (short var)
	{	
		short retVal;
		
		if(var > 255)
		{
			retVal = 255;	
		} 
		else if(var < 0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = var;	
		}
		
		return retVal;
	}		
	
   /**
     * DoubleWrap : 0 ϴ 0, 255 ̻ 0,1,2,... argument type integer.
	 *
     * @return    Wrap , double  ȯ
     */
	public static double DoubleWrap (int var)
	{	
		double retVal;
		
		if(var > 255)
		{
			retVal = var % 256;	
		} 
		else if(var < 0)
		{
			retVal = 0.0;
		}
		else 
		{
			retVal = (double) var;	
		}
		
		return retVal;
	}	

   /**
     * DoubleWrap : 0 ϴ 0, 255 ̻ 0,1,2,.. argument type double.
	 *
     * @return    Wrap , double  ȯ
     */
	public static double DoubleWrap (double var)
	{	
		double retVal;
		
		if(var > 255.0)
		{
			retVal = var % 256.0;	
		} 
		else if(var < 0.0)
		{
			retVal = 0.0;
		}
		else 
		{
			retVal =  var;	
		}
		
		return retVal;
	}	
	
   /**
     * IntWrap : 0 ϴ 0, 255 ̻ 0,1,2,..argument type double.
	 *
     * @return    Wrap , integer  ȯ
     */
	public static int IntWrap (double var)
	{	
		int retVal;
		
		if(var > 255.0)
		{
			retVal = (int)var % 256;		
		} 
		else if(var < 0.0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = (int)var;	
		}
		
		return retVal;
	}	

   /**
     * IntWrap : 0 ϴ 0, 255 ̻ 0,1,2,.. argument type int.
	 *
     * @return    Wrap , integer  ȯ
     */
	public static int IntWrap (int var)
	{	
		int retVal;
		
		if(var > 255)
		{
			retVal = var % 256;	
		} 
		else if(var < 0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = var;	
		}
		
		return retVal;
	}	

   /**
     * ShortWrap : 0 ϴ 0, 255 ̻ 0,1,2,.. argument type double.
	 *
     * @return    Wrap , short  ȯ
     */
	public static short ShortWrap (double var)
	{	
		short retVal;
		
		if(var > 255.0)
		{
			retVal = (short)(var % 255.0);	
		} 
		else if(var < 0.0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = (short)var;	
		}
		
		return retVal;
	}	

   /**
     * ShortWrap : 0 ϴ 0, 255 ̻ 0,1,2,.. argument type int.
	 *
     * @return    Wrap , short  ȯ
     */
	public static short ShortWrap (int var)
	{	
		short retVal;
		
		if(var > 255)
		{
			retVal = (short)(var % 256);	
		} 
		else if(var < 0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = (short)var;	
		}
		
		return retVal;
	}	

   /**
     * ShortWrap : 0 ϴ 0, 255 ̻ 0,1,2,.. argument type short.
	 *
     * @return    Wrap , short  ȯ
     */
	public static short ShortWrap (short var)
	{	
		short retVal;
		
		if(var > 255)
		{
			retVal = (short)(var % 256);	
		} 
		else if(var < 0)
		{
			retVal = 0;
		}
		else 
		{
			retVal = var;	
		}
		
		return retVal;
	}
}
