/**
 * Class Name	: DiffIMGBuf
 * Description	: ΰ   ȭҰ 
 * Date 				: 2003/01/21
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/01/21 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ΰ  ۳ ȭҰ Ѵ. ,     ˻  Ѵ.<p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class DiffIMGBuf
{
	private DiffIMGBuf() {}	

	/**
	 * ΰ  ۳ ȭҰ Ѵ.  true, ٸ false ȯѴ.
	 * 
	 * @param Image1	 
	 * @param Image2  
	 * @exception  ImageGSException Image1 Ǵ Image2  ϳ null  , mage1 Image2 ũⰡ ġ  
	 */	
	public static boolean comp(short[][] Image1, short[][] Image2)
							throws ImageGSException
	{
		return comp(Image1, Image2, false);
	}
	
	/**
	 * ΰ  ۳ ȭҰ Ѵ. ⼭ ̳  System.out  ѷش. <br>
	 *  true, ٸ false ȯѴ.
	 * 
	 * @param Image1	 
	 * @param Image2  
	 * @param display System.out.println  ̳ ȭҰ, ġ  	
	 * @exception  ImageGSException Image1 Ǵ Image2  ϳ null  , mage1 Image2 ũⰡ ġ  
	 */	
	public static boolean comp(short[][] Image1, short[][] Image2, boolean display)
							throws ImageGSException
	{
		int Image1_height;
		int Image1_width;
		int Image2_height;
		int Image2_width;
		boolean retval = true;
		int count = 0;
		
		// Image1 Image2 ϳ ϰ ܻȲ .
		if(Image1 == null || Image2 == null)
		{			
			throw new ImageGSException( "DiffIMGBuf.comp() >>  "
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );
		}

		//   ̿ ʺ Ѵ.
		Image1_height = GetSizeIMG.getHeight(Image1);
		Image1_width = GetSizeIMG.getWidth(Image1);
		Image2_height = GetSizeIMG.getHeight(Image2);
		Image2_width = GetSizeIMG.getWidth(Image2);
		
		// Image1 Image2 ũⰡ ġ    Ȳ .				
		if(Image1_height != Image2_height && Image1_width != Image2_width)
		{
			throw new ImageGSException( "DiffIMGBuf.comp() >>  "
				+ ErrorMsg.ERRORNOTEQUALHEIGHTWIDTHOFTWOIMAGES );	
		}
		
		for(int i=0; i<Image1_height; i++)
		{
			for(int j=0; j<Image2_width; j++)
			{
				if(Image1[i][j] != Image2[i][j])
				{
					if(display == false)
					{
						retval = false;
						break;	
					}
					else 
					{
						System.out.println( "[" + i + "," + j + "] " + Image1[i][j] + " <-> " + Image2[i][j] ); 	
						count++;
					}
				}		
			}
		}
		
		if(display == true) 
		{
			System.out.println("Detect count of pixel value of images ==> " + count); 	
		}
			
		return retval;				
	}	

	/**
	 * ΰ  ۳ ȭҰ Ѵ.  true, ٸ false ȯѴ.
	 * 
	 * @param Image1	 
	 * @param Image2  
	 * @exception ImageGSException Image1 Ǵ Image2  ϳ null  , mage1 Image2 ũⰡ ġ  
	 */	
	public static boolean comp(double[][] Image1, double[][] Image2) throws ImageGSException
	{
		
		return comp(Image1, Image2, false);
	}
	
	/**
	 * ΰ  ۳ ȭҰ Ѵ. ⼭ ̳  System.out  ѷش.<br>
	 *  true, ٸ false ȯѴ.
	 * 
	 * @param Image1	 
	 * @param Image2  
	 * @param display System.out.println  ̳ ȭҰ, ġ  	
	 * @exception  ImageGSException Image1 Ǵ Image2  ϳ null  , mage1 Image2 ũⰡ ġ  
	 */	
	public static boolean comp(double[][] Image1, double[][] Image2, boolean display) throws ImageGSException
	{
		int Image1_height;
		int Image1_width;
		int Image2_height;
		int Image2_width;
		boolean retval = true;
		int count = 0;
		
		// Image1 Image2 ϳ ϰ ܻȲ .
		if(Image1 == null || Image2 == null)
		{			
			throw new ImageGSException( "DiffIMGBuf.comp() >>  "
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );
		}

		//   ̿ ʺ Ѵ.
		Image1_height = GetSizeIMG.getHeight(Image1);
		Image1_width = GetSizeIMG.getWidth(Image1);
		Image2_height = GetSizeIMG.getHeight(Image2);
		Image2_width = GetSizeIMG.getWidth(Image2);
		
		// Image1 Image2 ũⰡ ġ    Ȳ .				
		if(Image1_height != Image2_height && Image1_width != Image2_width)
		{
			throw new ImageGSException( "DiffIMGBuf.comp() >>  "
				+ ErrorMsg.ERRORNOTEQUALHEIGHTWIDTHOFTWOIMAGES );	
		}
		
		for(int i=0; i<Image1_height; i++)
		{
			for(int j=0; j<Image2_width; j++)
			{
				if(Image1[i][j] != Image2[i][j])
				{
					if(display == false)
					{
						retval = false;
						break;	
					}
					else 
					{
						System.out.println( "[" + i + "," + j + "] " + Image1[i][j] + " <-> " + Image2[i][j] ); 	
						count++;
					}
				}		
			}
		}
		
		if(display == true) 
		{
			System.out.println("Detect count of pixel value of images ==> " + count); 	
		}
			
		return retval;			
	}	
} 


