/**
 * Class Name	: FillIMGBuf
 * Description	:    ۸ ä Ŭ
 * Date 				: 2002/11/08
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/08 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 *    ۸ ä.
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class FillIMGBuf
{
	/**
	 * 
	 */
	private FillIMGBuf() {}	
	
    /**
     *   ä, short Ÿ   ۷ ȯѴ.
     * 
     * @param	constant 	 (0~255)
     * @param	height	
     * @param	width	ʺ
     * @return    short type[][]   ȯ
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static short [][] FillShortGrayIMGBuf (short constant, int height, int width) throws ImageGSException	
	{
		short[][] TargetGrayIMGBuf = null;
		short s_constant = (short)constant;	
		
		// ̿ ʺ 0 
		if(height <= 0 || width <=0)
		{
			throw new ImageGSException("FillIMGBuf.FillShortGrayIMGBuf() >> "
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO ); 				
		}
		
		if(constant < 0 || constant > 255)
		{
			throw new ImageGSException("FillIMGBuf.FillShortGrayIMGBuf() >> "
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
				
		try{
					
			TargetGrayIMGBuf = InitIMGBuf.ShortIMGBuf(height, width);
			
			//copy
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					TargetGrayIMGBuf[i][j] = s_constant;
				}
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("FillIMGBuf.FillShortGrayIMGBuf() >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}

    /**
     *   ä, integer Ÿ   ۷ ȯѴ.
     * 
     * @param	constant 	 (0~255)
     * @param	height	
     * @param	width	ʺ
     * @return    integer type[][]   ȯ
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static int [][] FillIntegerGrayIMGBuf (int constant, int height, int width) throws ImageGSException	
	{
		int [][] TargetGrayIMGBuf = null;
		int i_constant = (int)constant;	
		
		// ̿ ʺ 0 
		if(height <= 0 || width <=0)
		{
			throw new ImageGSException("FillIMGBuf.FillIntegerGrayIMGBuf() >> "
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO ); 				
		}
		
		if(constant < 0 || constant > 255)
		{
			throw new ImageGSException("FillIMGBuf.FillIntegerGrayIMGBuf() >> "
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
				
		try{
					
			TargetGrayIMGBuf = InitIMGBuf.IntegerIMGBuf(height, width);
			
			//copy
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					TargetGrayIMGBuf[i][j] = i_constant;
				}
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("FillIMGBuf.FillDoubleGrayIMGBuf() >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}
	
    /**
     *   ä, double Ÿ   ۷ ȯѴ.
     * 
     * @param	constant 	 (0~255)
     * @param	height	
     * @param	width	ʺ
     * @return    double type[][]   ȯ
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static double [][] FillDoubleGrayIMGBuf (double constant, int height, int width) throws  ImageGSException	
	{
		double[][] TargetGrayIMGBuf = null;
		double d_constant = (double)constant;	
		
		// ̿ ʺ 0 
		if(height <= 0.0 || width <=0.0)
		{
			throw new ImageGSException("FillIMGBuf.FillDoubleGrayIMGBuf() >> "
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO ); 				
		}
		
		if(constant < 0.0 || constant > 255.0)
		{
			throw new ImageGSException("FillIMGBuf.FillDoubleGrayIMGBuf() >> "
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
				
		try{
					
			TargetGrayIMGBuf = InitIMGBuf.DoubleIMGBuf(height, width);
			
			//copy
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					TargetGrayIMGBuf[i][j] = d_constant;
				}
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("FillIMGBuf.FillDoubleGrayIMGBuf() >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}

}

