/**
 * Class Name	: GetIMGBufType
 * Description	: ش   Ÿ ˾Ƴ.
 * Date 				: 2004/03/19
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2004/03/19 first created.
 */
package com.conv2.imageGS.Util;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;

import com.conv2.imageGS.Exception.ImageGSException;

/**
 * 
 * ش   Ÿ ÷/ϵ/ ǴѴ. 
 *
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class GetIMGBufferType 
{
	private GetIMGBufferType() {}
	
	/**
	 *   ̸ , ƴϸ  ȯѴ.
	 * 
	 * @param image  
	 * @return / 
	 */
	public static boolean isBinary( Object image ) throws ImageGSException
	{
		boolean isBinaryImage = false;
		
		if( image == null )
		{
			throw new ImageGSException(
				GetIMGBufferType.class.getClass().getName()
					+ ">> image is null!!" );
		}
		
		try
		{
			if( image instanceof BufferedImage )
			{
				if( checkBufferedImage( (BufferedImage) image ) == 0 ) isBinaryImage = true;
			}
			else if( image instanceof short[][] ) 
			{
				isBinaryImage = isBinary(  TypeConv2GrayIMG.Short2DoubleGrayIMG( (short [][])image ) );
			}
			else if( image instanceof double[][] )
			{
				isBinaryImage = isBinary( (double[][]) image );
			}
		}
		catch(ImageGSException e)
		{
			throw e;
		}
		
		return isBinaryImage;
	}
	
	/**
	 * ϵ  ̸ , ƴϸ  ȯѴ.
	 * 
	 * @param image  
	 * @return / 
	 */
	public static boolean isGray( Object image ) throws ImageGSException
	{
		boolean isGrayImage = false;
		
		if( image == null )
		{
			throw new ImageGSException(
				GetIMGBufferType.class.getClass().getName()
					+ ">> image is null!!" );
		}

		try
		{
			if( image instanceof BufferedImage )
			{
				if( checkBufferedImage( (BufferedImage) image ) == 1 ) isGrayImage = true;
			}
			else if( image instanceof short[][] ) 
			{
				isGrayImage = !isBinary( TypeConv2GrayIMG.Short2DoubleGrayIMG( (short [][])image ) );
			}
			else if( image instanceof double[][] )
			{
				isGrayImage = !isBinary( (double[][]) image );
			}
		}
		catch(ImageGSException e)
		{
			throw e;
		}
		
		return isGrayImage;
	}	
	
	/**
	 * ÷  ̸ , ƴϸ  ȯѴ.
	 * 
	 * @param image  
	 * @return / 
	 */
	public static boolean isColor( BufferedImage image ) throws ImageGSException
	{
		boolean isColorImage = false;
		
		if( image == null )
		{
			throw new ImageGSException(
				GetIMGBufferType.class.getClass().getName()
					+ ">> image is null!!" );
		}

		if( checkBufferedImage( image ) == 2 ) isColorImage = true;
		
		return isColorImage;
	}		

	/** 
	 * 
	 * bi  Ÿ ȯѴ.
	 * 
	 * @param bi BufferedImage Ÿ   
	 * @return  0 : , 1 : ϵ, 2 : ÷
	 * @throws ImageGSException
	 */
	public static int checkBufferedImage( BufferedImage bi ) throws ImageGSException
	{
		// ̿ ʺ Ѵ.
		int height = bi.getHeight();
		int width = bi.getWidth();
		int rotateType = 0;
		int ROTATE_Y = 0;
		int ROTATE_N = 1;
		int BINARY = 0;
		int GRAY = 1;
		int COLOR = 2;
		int imageType = -1;
		int[] histogram = new int[256];
		
		// height width ݴ   ִ ȮѴ.
		int tmpHeight = width;
		int tmpWidth = height;
		
		if( tmpHeight == width && tmpWidth == height )
		{
			rotateType = ROTATE_Y;
		}
		else 
		{
			rotateType = ROTATE_N;
		}
		
		// rotate̸ ٷ ش.
		if( rotateType == ROTATE_Y ) 
		{
			// swap
			int tmp = height ;
			height = width;
			width = tmp;
		}
		
		short[][] image = InitIMGBuf.ShortIMGBuf( height, width );
		Raster raster = bi.getData();
		int[] data = new int[3];
		
		data = raster.getPixel( 0, 0, (int[]) null );
		
		// 32 bit ̸̻  ʴ´.
		if( data.length > 3 ) 
		{
			throw new ImageGSException(
				GetIMGBufferType.class.getClass().getName()
					+ ">> this BufferedImage data not support over 32 bi!");
		}
		
		if( data.length == 3 ) 
		{
			imageType = COLOR;
		}
		else 
		{	
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					data = raster.getPixel( i, j, (int[]) null );
					image[i][j] = (short)data[0];
					histogram[ image[i][j] ]++;
				}
			}	
			
			imageType = (checkHistogram( histogram ) ) ? BINARY : GRAY;
		}

		return imageType;
		
	}
	
	private static boolean checkHistogram( int[] histogram )
	{
		int pixels = 0;
		for(int i=2; i<256; i++)
		{
			if( histogram[i] != 0 ) pixels++;
		}
		
		return ( pixels == 0 ) ? true : false;
	}

	private static boolean isBinary( double[][] image ) throws ImageGSException
	{
		int height = GetSizeIMG.getHeight( image );
		int width = GetSizeIMG.getWidth( image );
		int[] histogram = new int[256];
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				histogram[ (int)image[i][j] ]++;
			}
		}
		
		return checkHistogram( histogram );
	}
}
