/**
 * Class Name	: GetValueArray
 * Description	: GetValueArray  Ŭ
 * Date 				: 2002/09/07
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/07 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * double, integer, short  1  array ġ شϴ   Ǵ Ͽ ´. , float  ʴ´. <p>
 * 
 * <pre> 
 *      getMaxArray  : Array ִ밪 ´.
 *      getMinArray   : Array ּҰ ´.
 *      getMidArray   : Array ߰ ´.
 *      getMeanArray: Array  հ ´.
 * 
 * []
 * 
 * public class Test {
 *	
 *	// main()
 *	public static void main(String[] args)
 *	{
 *		int [] array = new int[3];
 *		array[0] = 3; array[1] = 0; array[2] = -1;
 *		
 *		try {
 *			System.out.println("sorting  ʾҴٴ Ͽ մϴ.");
 *			System.out.println("Get min value : " + GetValueArray.getMinArray(array, 0));
 *			System.out.println("Get max value : " + GetValueArray.getMaxArray(array, 0));
 *			System.out.println("Get mid value : " + GetValueArray.getMidArray(array, 0));
 *			System.out.println("Get mean value : " + GetValueArray.getMeanArray(array));
 *			
 *			QuickSort.seq_quicksort(3, array, 0);
 *			System.out.println("sorting Ǿٴ  Ͽ մϴ.");
 *			System.out.println("Get min value : " + GetValueArray.getMinArray(array));
 *			System.out.println("Get max value : " + GetValueArray.getMaxArray(array));
 *			System.out.println("Get mid value : " + GetValueArray.getMidArray(array));
 *			System.out.println("Get mean value : " + GetValueArray.getMeanArray(array));			
 *		} 
 *		catch(ImageGSException e)
 *		{
 *			System.out.println(e.getMessage());
 *			System.exit(1);	
 *		}
 *	}
 * }
 * </pre>		
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 *
 */
public class GetValueArray
{
	/**
	 * 
	 */
	private GetValueArray() {};


////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
/////////////////////////////                  double                     ////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	/**
	 * 1 array ִ밪 ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * </pre>
	 * 
	 * @param	Arraylist	double type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static double getMaxArray(double[] Arraylist, int Sort_method) throws ImageGSException
	{
		double RetVal = 0.0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMaxArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// ArraylistũⰡ 1϶ ׳ ش.
		//  ߰߳İ?  쿡 ؼ...
		if(Arraylist_length == 1) return Arraylist[0];
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[ Arraylist_length - 1];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[ Arraylist_length - 1];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMAxArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ִ밪 ´. <p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	double type array
	 * @exception	ImageGSException
	 */	
	public static double getMaxArray(double[] Arraylist) throws ImageGSException
	{
		double RetVal = 0.0;
		
		try 
		{
			RetVal = getMaxArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}

	/**
	 * 1 array ּҰ ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. 
	 * 								sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * </pre>
	 * 
	 * @param	Arraylist	double type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static double getMinArray(double[] Arraylist, int Sort_method) throws ImageGSException
	{
		double RetVal = 0.0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMinArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[0];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[0];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMinArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ּҰ ´. <p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	double type array
	 * @exception	ImageGSException
	 */	
	public static double GetMinArray(double[] Arraylist) throws ImageGSException
	{
		double RetVal = 0.0;
		
		try 
		{
			RetVal = getMinArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}
	
	/**
	 * 1 array ߰ ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. 
	 * 								sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * 
	 * 	, array ũⰡ Ȧ ΰ쿡  ,
	 * 	¦  ߰ ġ ָϴٴ  ϶.
	 * </pre>
	 * 
	 * @param	Arraylist	double type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static double getMidArray(double[] Arraylist, int Sort_method) throws ImageGSException
	{
		double RetVal = 0.0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// ArraylistũⰡ 1϶ ׳ ش.
		//  ߰߳İ?  쿡 ؼ...
		if(Arraylist_length == 1) return Arraylist[0];
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[ Arraylist_length/2 ];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[ Arraylist_length/2 ];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ߰ ´.  array ũⰡ ¦  ġ ָϴٴ  ϶.<p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	double type array
	 * @exception	ImageGSException
	 */	
	public static double getMidArray(double[] Arraylist) throws ImageGSException
	{
		double RetVal = 0.0;
		
		try 
		{
			RetVal = getMidArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}	
	
	/**
	 * 1 array հ ´. 
	 * 
	 * @param	Arraylist	double type array
	 * @exception	ImageGSException
	 */
	public static double getMeanArray(double[] Arraylist) throws ImageGSException
	{
		double RetVal = 0.0;
		double sum = 0.0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		for(int i = 0; i<Arraylist_length; i++)
		{
			sum += Arraylist[i];
		}
		
		RetVal = sum / (double)Arraylist_length;
		
		return RetVal;
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
/////////////////////////////                  integer                     ////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	/**
	 * 1 array ִ밪 ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * </pre>
	 * 
	 * @param	Arraylist	integer type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static int getMaxArray(int[] Arraylist, int Sort_method) throws ImageGSException
	{
		int RetVal = 0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMaxArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// ArraylistũⰡ 1϶ ׳ ش.
		//  ߰߳İ?  쿡 ؼ...
		if(Arraylist_length == 1) return Arraylist[0];
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[ Arraylist_length - 1];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[ Arraylist_length - 1];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMAxArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ִ밪 ´. <p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	integer type array
	 * @exception	ImageGSException
	 */	
	public static int getMaxArray(int[] Arraylist) throws ImageGSException
	{
		int RetVal = 0;
		
		try 
		{
			RetVal = getMaxArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}

	/**
	 * 1 array ּҰ ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. 
	 * 								sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * </pre>
	 * 
	 * @param	Arraylist	integer type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static int getMinArray(int[] Arraylist, int Sort_method) throws ImageGSException
	{
		int RetVal = 0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMinArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[0];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[0];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMinArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ּҰ ´. <p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	integer type array
	 * @exception	ImageGSException
	 */	
	public static int getMinArray(int[] Arraylist) throws ImageGSException
	{
		int RetVal = 0;
		
		try 
		{
			RetVal = getMinArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}
	
	/**
	 * 1 array ߰ ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. 
	 * 								sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * 
	 * 	, array ũⰡ Ȧ ΰ쿡  ,
	 * 	¦  ߰ ġ ָϴٴ  ϶.
	 * </pre>
	 * 
	 * @param	Arraylist	integer type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static int getMidArray(int[] Arraylist, int Sort_method) throws ImageGSException
	{
		int RetVal = 0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// ArraylistũⰡ 1϶ ׳ ش.
		//  ߰߳İ?  쿡 ؼ...
		if(Arraylist_length == 1) return Arraylist[0];
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[ Arraylist_length/2 ];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[ Arraylist_length/2 ];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ߰ ´.  array ũⰡ ¦  ġ ָϴٴ  ϶.<p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	integer type array
	 * @exception	ImageGSException
	 */	
	public static int getMidArray(int[] Arraylist) throws ImageGSException
	{
		int RetVal = 0;
		
		try 
		{
			RetVal = getMidArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}	
	
	/**
	 * 1 array հ ´. 
	 * 
	 * @param	Arraylist	integer type array
	 * @exception	ImageGSException
	 */
	public static double getMeanArray(int[] Arraylist) throws ImageGSException
	{
		double RetVal = 0.0;
		double sum = 0.0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		for(int i = 0; i<Arraylist_length; i++)
		{
			// implicit type casting
			sum += Arraylist[i];
		}
		
		RetVal = sum / (double)Arraylist_length;
		
		return RetVal;
	}
	
////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
/////////////////////////////                  short                       ////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

	/**
	 * 1 array ִ밪 ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * </pre>
	 * 
	 * @param	Arraylist	short type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static short getMaxArray(short[] Arraylist, int Sort_method) throws ImageGSException
	{
		short RetVal = 0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMaxArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// ArraylistũⰡ 1϶ ׳ ش.
		//  ߰߳İ?  쿡 ؼ...
		if(Arraylist_length == 1) return Arraylist[0];
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[ Arraylist_length - 1];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[ Arraylist_length - 1];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMAxArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ִ밪 ´. <p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	short type array
	 * @exception	ImageGSException
	 */	
	public static short getMaxArray(short[] Arraylist) throws ImageGSException
	{
		short RetVal = 0;
		
		try 
		{
			RetVal = getMaxArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}

	/**
	 * 1 array ּҰ ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. 
	 * 								sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * </pre>
	 * 
	 * @param	Arraylist	short type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static short getMinArray(short[] Arraylist, int Sort_method) throws ImageGSException
	{
		short RetVal = 0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMinArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[0];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[0];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMinArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ּҰ ´. <p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	short type array
	 * @exception	ImageGSException
	 */	
	public static short getMinArray(short[] Arraylist) throws ImageGSException
	{
		short RetVal = 0;
		
		try 
		{
			RetVal = getMinArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}
	
	/**
	 * 1 array ߰ ´. <p>
	 * 
	 * <pre>
	 * 	Sort_method  0	-	Arraylist sorting  ʾҴ. 
	 * 								sorting   ȯѴ.
	 * 
	 * 	Sort_method	1	-	Arraylist ̹ sorting Ǿ ־.
	 * 
	 * 	, array ũⰡ Ȧ ΰ쿡  ,
	 * 	¦  ߰ ġ ָϴٴ  ϶.
	 * </pre>
	 * 
	 * @param	Arraylist	short type array
	 * @param	Sort_method	Ŀ
	 * @exception	ImageGSException
	 */
	public static short getMidArray(short[] Arraylist, int Sort_method) throws ImageGSException
	{
		short RetVal = 0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		// ArraylistũⰡ 1϶ ׳ ش.
		//  ߰߳İ?  쿡 ؼ...
		if(Arraylist_length == 1) return Arraylist[0];
		
		// sorting Ǿ   
		if(Sort_method == 0) 
		{
			QuickSort.seq_quicksort(Arraylist_length, Arraylist, 0);		
			RetVal = Arraylist[ Arraylist_length/2 ];	
		}
		// sorting ̹ Ǿ   
		else if(Sort_method == 1) 
		{
			RetVal = Arraylist[ Arraylist_length/2 ];
		}	
		// ƴϸ  ش.
		else 
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORMISSMETHOD );	
		}	
		
		return RetVal;
	}

	/**
	 * 1 array ߰ ´.  array ũⰡ ¦  ġ ָϴٴ  ϶.<p>
	 * 
	 * ⺻ sorting    sorting   ȯѴ.
	 * 
	 * @param	Arraylist	short type array
	 * @exception	ImageGSException
	 */	
	public static short getMidArray(short[] Arraylist) throws ImageGSException
	{
		short RetVal = 0;
		
		try 
		{
			RetVal = getMidArray(Arraylist, 0);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
		
		return RetVal;
	}	
	
	/**
	 * 1 array հ ´. 
	 * 
	 * @param	Arraylist	short type array
	 * @exception	ImageGSException
	 */
	public static double getMeanArray(short[] Arraylist) throws ImageGSException
	{
		double RetVal = 0.0;
		double sum = 0.0;
		
		if(Arraylist == null)
		{
			throw new ImageGSException("GetValueArray.GetMidArray() >> " + ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// ش Arraylist ũ⸦ Ѵ.
		int Arraylist_length = Arraylist.length;
		
		for(int i = 0; i<Arraylist_length; i++)
		{
			// implicit type casting
			sum += Arraylist[i];
		}
		
		RetVal = sum / (double)Arraylist_length;
		
		return RetVal;
	}
}
