/**
 * Class Name	: SystemDate
 * Description	: ýۻ  ð, ¥  Ŭ
 * Date 				: 2002/12/20
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/20 first created.
 */

package com.conv2.imageGS.Util;

/**
 * ¥, ð ´.  Ŭ  Ǵ α 涧  ̴.
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public final class SystemDate 
{
	private static String timeZone = "GMT+09:00";

	private SystemDate() {}

	/**
	 * format ߾  ¥ String ȯѴ.
	 * ( : "yyyy-MM-dd HH:mm:ss:SSS")
	 *
	 * @param format ¥ format
	 * @return        ¥
	 */
	public static String getDateString(String format) 
	{
		java.text.SimpleDateFormat simpleFormat = new java.text.SimpleDateFormat(format);
		java.util.TimeZone tz  = java.util.TimeZone.getTimeZone(timeZone);
		java.util.Calendar cal = java.util.Calendar.getInstance(tz, java.util.Locale.KOREAN);

		simpleFormat.setTimeZone(tz);
		return simpleFormat.format(cal.getTime());
	}

	/**
	 * format ߾  ¥ String ȯѴ.
	 * ȯǴ  yyyy-MM-dd HH:mm:ss:SSS ̴.
	 *
	 * @return        ¥
	 */
	public static String getDateString() 
	{
		String format = "yyyy-MM-dd HH:mm:ss:SSS";
		return getDateString(format);
	}

	/**
	 * format ߾  ¥ String ȯѴ.
	 * ȯǴ  yyyyMMddHHmmssSSS ̴.
	 *
	 * @return        ¥
	 */
	public static String getLongDateString() 
	{
		String format = "yyyyMMddHHmmssSSS";
		return getDateString(format);
	}
		
	/**
	 * format ߾ ־ ¥ String ȯѴ.( : "yyyy-MM-dd HH:mm:ss:SSS")
	 *
	 * @param date   String ǥ ¥
	 * @param format ¥ format
	 * @return       String ȯ ¥
	 */
	public static String dateToString(java.util.Date date, String format) 
	{
		java.text.SimpleDateFormat simpleFormat = new java.text.SimpleDateFormat(format);
		java.util.TimeZone tz  = java.util.TimeZone.getTimeZone(timeZone);
		simpleFormat.setTimeZone(tz);
		return simpleFormat.format(date);
	}
	
	/**
	 *  ¥ ȯѴ(Date type).
	 *
	 * @return  ¥
	 */
	public static java.util.Date getDate() 
	{
		java.util.TimeZone tz  = java.util.TimeZone.getTimeZone(timeZone);
		java.util.Calendar cal = java.util.Calendar.getInstance(tz, java.util.Locale.KOREAN);

		return cal.getTime();
	}
	
}

